/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.facade.controller;

import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.param.VirtualUserRandomQueryParam;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.vo.VirtualUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/facade/manage/virutal/user"})
public class VirtualUserFacadeController {
    private final VirtualUserService virtualUserService;
    private final VirtualUserMapper virtualUserMapper;

    @Autowired
    public VirtualUserFacadeController(VirtualUserService virtualUserService, VirtualUserMapper virtualUserMapper) {
        this.virtualUserService = virtualUserService;
        this.virtualUserMapper = virtualUserMapper;
    }

    @GetMapping(value={"exists"})
    public ResponseEntity<Boolean> exists(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.virtualUserMapper.exists(userId));
    }

    @PostMapping(value={"random"})
    public ResponseEntity<List<VirtualUser>> getRandom(@RequestBody VirtualUserRandomQueryParam param) {
        List virtualUsers = null != param.getDeliveryType() || null != param.getIncludeAreaCodes() ? this.virtualUserMapper.selectRandModelByMutiAreaCode(param) : this.virtualUserMapper.selectRandModel(param);
        return ResponseEntity.ok((Object)virtualUsers);
    }

    @PostMapping(value={"list"})
    public ResponseEntity<List<VirtualUserOverviewDTO>> list(@RequestBody VirtualUserQueryParam param) {
        return ResponseEntity.ok((Object)this.virtualUserService.list(param));
    }
}

