package com.bxm.localnews.admin.dto;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Dong_hy
 */
@Data
@ApiModel(description = "红包DTO")
public class RedPacketDTO extends PageParam implements Serializable {
    /**
     * 主键
     */
    @ApiModelProperty("红包id")

    private Long id;

    /**
     * 发送红包的用户ID
     */
    @ApiModelProperty("发送红包的用户ID")

    private Long userId;

    /**
     * 发放红包的用户名
     */
    @ApiModelProperty("发放红包的用户名")
    private String userName;

    /**
     * 用户头像地址
     */
    @ApiModelProperty("用户头像地址")
    private String userImg;

    /**
     * 红包金额
     */
    @ApiModelProperty("红包金额")
    private BigDecimal amount;

    /**
     * 剩余红包金额
     */
    @ApiModelProperty("剩余红包金额")
    private BigDecimal surplusAmount;

    /**
     * 已领红包金额
     */
    @ApiModelProperty("已领红包金额")
    private BigDecimal receivedAmount;

    /**
     * 期望发送数量
     */
    @ApiModelProperty("期望发送数量")
    private Integer expectNum;

    /**
     * 实际发放数量
     */
    @ApiModelProperty("实际发放数量")
    private Integer actualNum;

    /**
     * 审核状态（0:等待审核,1:审核通过,2：审核拒绝）
     */
    @ApiModelProperty("审核状态（0:等待审核,1:审核通过,2：审核拒绝）")
    private Integer activeStatus;

    /**
     * 红包领取状态（1：可领取，0：已领完）
     */
    @ApiModelProperty("红包领取状态（1：可领取，0：已领完）")
    private Integer obtainStatus;

    /**
     * 是否在线(1：在线，0：下线)
     */
    @ApiModelProperty("是否在线(1：在线，0：下线)")
    private Integer onlineStatus;

    /**
     * 红包类型（1:红包墙，2：微信红包）
     */
    @ApiModelProperty("红包类型（1:红包墙，2：微信红包）")
    private Integer packetType;

    /**
     * 采用的绕口令ID
     */
    @ApiModelProperty("采用的绕口令ID")
    private Long twisterId;

    /**
     * 红包文字内容
     */
    @ApiModelProperty("红包文字内容")
    private String content;

    /**
     * 宣传文案文字内容
     */
    @ApiModelProperty("宣传文案文字内容")
    private String promotionContent;

    /**
     * 地区code
     */
    @ApiModelProperty("地区code")
    private String areaCode;

    /**
     * 地区名称
     */
    @ApiModelProperty("地区名称")
    private String areaName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 记录版本，默认从0开始，更新一次后+1
     */
    @ApiModelProperty("记录版本，默认从0开始，更新一次后+1")
    private Integer version;

    /**
     * 最后变更时间（变更内容时记录，领取时不记录）
     */
    @ApiModelProperty("最后变更时间（变更内容时记录，领取时不记录）")
    private Date modifyTime;

    /**
     * 宣传文案图片部分（使用Json格式数组存储）
     */
    @ApiModelProperty("宣传文案图片部分（使用Json格式数组存储）")
    private String promotionImg;

    /**
     * 审核意见
     */
    @ApiModelProperty("审核意见")
    private String comment;
}