package com.bxm.localnews.admin.param;

import java.util.Date;

import com.bxm.newidea.component.vo.PageParam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(description = "广告")
public class AdvertParam extends PageParam {

    @ApiModelProperty("名称")
    private String title;

    @ApiModelProperty("广告类型 1：首页弹窗广告 2：个人中心随机广告  3：赚钱中心轮播广告 4：列表广告 " +
            "5：赚钱中心公告 6：首页悬浮广告 7:开屏广告")
    private String type;

    @ApiModelProperty("状态 1：上架 2：下架  3：删除")
    private Byte status;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

}
