package com.bxm.localnews.admin.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Gonzo
 * @date 2019-11-01 10:55
 */
@Data
@ApiModel(description = "创建聊天室定时红包计划参数")
public class CreateTimingRedPacketPlanParam {

    @ApiModelProperty("聊天室id")
    @NotEmpty(message = "聊天室id不能为空")
    private String chatRoomId;

    @ApiModelProperty("每日定时发送的时间")
    @NotNull(message = "发送时间不能为空")
    @JsonFormat(pattern = "HH:mm")
    private Date sentTime;

    @ApiModelProperty("红包金额 单位元")
    @NotNull(message = "红包金额不能为空")
    private BigDecimal redPacketTotalAmount;

    @ApiModelProperty("红包总可领取数")
    @NotNull(message = "红包总可领取数不能为空")
    private Integer redPacketTotalNum;


}
