package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Tolerate;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ApiModel("帖子参数实体")
@Data
@Builder
public class ForumPostParam extends PageParam {

    @Tolerate
    public ForumPostParam(){

    }

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("审核状态：0拒绝 1通过 2待审核")
    private Integer status;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Integer isBrilliant;

    @ApiModelProperty("是否推荐：0否 1是")
    private Integer isRecommend;

    @ApiModelProperty("展示标签：1热 2爆")
    private Integer displayTag;

    @ApiModelProperty("所属版块id")
    private Long forumId;

    @ApiModelProperty("所属话题id")
    private Long topicId;

    @ApiModelProperty("发帖人id")
    private Long userId;

    @ApiModelProperty("发帖人姓名")
    private String userName;

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("定时发布时间开始时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishStartTime;

    @ApiModelProperty("定时发布时间结束时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishEndTime;

    @ApiModelProperty("是否0评论：0否 1是")
    private Integer isZeroReply;

}
