package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "拉黑用户参数")
@Data
public class ImBlockParam {
    @ApiModelProperty("拉黑的用户ID")
    private Long userId;

    @ApiModelProperty("屏蔽开始时间，SDK不支持，设置无意义")
    @Deprecated
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("屏蔽截止时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date endTime;
}
