package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ApiModel(description = "聊天记录查询参数")
@Data
public class ImMessageQueryParam {
    @ApiModelProperty("发起聊天的用户ID")
    private Long sender;

    @ApiModelProperty("接收的用户ID")
    private Long receiver;

    @ApiModelProperty("消息内容")
    private String content;

    @ApiModelProperty("聊天发送开始时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date startTime;

    @ApiModelProperty("聊天发送截止时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date endTime;
}
