package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Dong_hy
 */
@Data
@ApiModel(description = "红包请求参数")
public class RedPacketParam extends PageParam implements Serializable {

    @ApiModelProperty("红包id")
    private Long id;

    @ApiModelProperty("发送红包的用户ID")
    private Long userId;

    @ApiModelProperty("红包文字内容")
    private String content;

    @ApiModelProperty("发放红包的用户名")
    private String userName;

    @ApiModelProperty("审核状态（0:等待审核,1:审核通过,2：审核拒绝）")
    private Integer activeStatus;

    @ApiModelProperty("红包领取状态（1：可领取，0：已领完）")
    private Integer obtainStatus;

    @ApiModelProperty("是否在线(1：在线，0：下线)")
    private Integer onlineStatus;

    @ApiModelProperty("1:红包墙，2：微信红包）")
    private Integer packetType;

    @ApiModelProperty("宣传文案文字内容")
    private String promotionContent;

    @ApiModelProperty("宣传文案图片部分（使用Json格式数组存储）")
    private String promotionImg;

    @ApiModelProperty("审核意见")
    private String comment;

    @ApiModelProperty("地区编码")
    private String areaCode;


}