package com.bxm.localnews.admin.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Gonzo
 * @date 2019-11-01 10:55
 */
@Data
@ApiModel(description = "更新聊天室定时红包计划参数")
public class UpdateTimingRedPacketPlanParam {

    @ApiModelProperty("id")
    @NotNull(message = "id不能为空")
    private Long id;

    @ApiModelProperty("每日定时发送的时间")
    @JsonFormat(pattern = "HH:mm")
    private Date sentTime;

    @ApiModelProperty("红包金额 单位元")
    private BigDecimal redPacketTotalAmount;

    @ApiModelProperty("红包总可领取数")
    private Integer redPacketTotalNum;

}
