package com.bxm.localnews.admin.vo;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/4/2 17:14
 * @desc
 */
@ApiModel(description = "线下推广码存放信息")
public class AreaPushCode {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("地区名称")
    private String areaName;

    @ApiModelProperty("对应模板")
    private String codeTemplate;

    @ApiModelProperty("生成的图片地址")
    private String codeUrl;

    @ApiModelProperty("绑定的用户id")
    private Long userId;

    @ApiModelProperty("是否协会人员")
    private Byte association = 0;

    @ApiModelProperty("用户备注信息")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更改时间")
    private Date modifyTime;

    public AreaPushCode() {
    }

    public AreaPushCode(Long id, String areaCode, String areaName, String codeTemplate, String codeUrl) {
        this.id = id;
        this.areaCode = areaCode;
        this.areaName = areaName;
        this.codeTemplate = codeTemplate;
        this.codeUrl = codeUrl;
        Date now = new Date();
        this.createTime = now;
        this.modifyTime = now;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getCodeTemplate() {
        return codeTemplate;
    }

    public void setCodeTemplate(String codeTemplate) {
        this.codeTemplate = codeTemplate;
    }

    public String getCodeUrl() {
        return codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Byte getAssociation() {
        return association;
    }

    public void setAssociation(Byte association) {
        this.association = association;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}
