package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel("新闻基础实体")
@Data
public class BaseNews extends BaseBean {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("内容中新闻网络图片地址（json数组字符串格式）")
    private String imgUrl;

    @ApiModelProperty("作者头像")
    private String authorImg;

    @ApiModelProperty("来源作者")
    private String author;

    @ApiModelProperty("来源地址")
    private String address;

    @ApiModelProperty("分类id（一篇文章对应一个分类）")
    private Integer kindId;

    @ApiModelProperty("浏览次数")
    private Long views;

    @ApiModelProperty("发布时间")
    private Date publishTime;

    @ApiModelProperty("新闻抓取时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("新闻发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date issueTime;

    @ApiModelProperty("状态 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("是否置顶 1：否 2：是")
    private Byte top;

    @ApiModelProperty("是否頻道置顶 1：否 2：是")
    private Byte kindTop;

    @ApiModelProperty("新闻类型  1：文章  2：组图  3：视频")
    private Byte type;

    @ApiModelProperty("新闻渠道 1：今日头条 2：搜狐 3:凤凰 4:UC,5网易,6猫扑,7快资讯")
    private Byte channel;

    @ApiModelProperty("标签")
    private String label;

    @ApiModelProperty("是否是热文 1：否  2：是")
    private Byte hot;

    @ApiModelProperty("热门过期时间")
    private Date hotExpireTime;

    @ApiModelProperty("置頂过期时间")
    private Date topExpireTime;

    @ApiModelProperty("审核状态  状态 0:待审核  1:已拒绝  2:已通过")
    private Byte reviewStatus;

    @ApiModelProperty("是否推荐 0:否  1是")
    private Byte isRecommend;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("编辑寄语")
    private String editorMessage;

    @ApiModelProperty("编辑寄语id")
    private Long editorMessageId;

    @ApiModelProperty("启用占位符")
    private Byte enablePlaceholder;

    @ApiModelProperty("新闻视频信息")
    private String videoList;

    @ApiModelProperty("封面图片（json字符串格式）")
    private String coverList;

    @ApiModelProperty("编辑寄语名称")
    private String editorMessageName;

    @ApiModelProperty("新闻视频信息")
    private String videoStr;

    @ApiModelProperty("封面选择 0:只取图片 ,1:只取第一个视频 ,2:取内容详情的视频和图片 ")
    private Byte coverSelect;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

}
