package com.bxm.localnews.admin.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


@ApiModel(description = "积分商城商品")
public class MarketCommodity implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("商品id")
    private Long id;

    @ApiModelProperty("商品名称")
    private String title;

    @ApiModelProperty("商品兑换价格")
    private BigDecimal price;

    @ApiModelProperty("兑换限制次数")
    private Integer maxNum;

    @ApiModelProperty("商品类型（VIRTUAL:虚拟商品，GOODS：实物），枚举定义，后续可扩展")
    private String type;

    @ApiModelProperty("状态：0：下架，1：上架")
    private Byte status;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建用户ID")
    private Long creator;

    @ApiModelProperty("平台ID（预留字段）")
    private Long platformId;

    @ApiModelProperty("排序权重")
    private Integer order;

    @ApiModelProperty("删除标记：0 正常，1 已删除")
    private Byte deleteFlag;

    @ApiModelProperty("图片数组, json格式")
    private String images;

    private Long deletor;

    private Date deleteTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getMaxNum() {
        return maxNum;
    }

    public void setMaxNum(Integer maxNum) {
        this.maxNum = maxNum;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Byte getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public String getImages() {
        return images;
    }

    public void setImages(String images) {
        this.images = images;
    }

    public Long getDeletor() {
        return deletor;
    }

    public void setDeletor(Long deletor) {
        this.deletor = deletor;
    }

    public Date getDeleteTime() {
        return deleteTime;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }
}