package com.bxm.localnews.admin.vo;

import java.util.Date;
import java.util.List;

import com.bxm.newidea.component.vo.BaseBean;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class User extends BaseBean {

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户密码")
    private String password;

    @ApiModelProperty("用户手机号码")
    private String phone;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty(hidden = true)
    private Integer age;

    @ApiModelProperty(hidden = true)
    private Byte sex;

    @ApiModelProperty(hidden = true)
    private Byte level;

    @ApiModelProperty(hidden = true)
    private String weixin;

    @ApiModelProperty(hidden = true)
    private String qq;

    @ApiModelProperty(hidden = true)
    private String weibo;

    @ApiModelProperty(hidden = true)
    private Byte state;

    @ApiModelProperty("用户访问凭证")
    private String token;

    @ApiModelProperty(hidden = true)
    private Long expiretime;

    @ApiModelProperty(hidden = true)
    private String refreshtoken;

    @ApiModelProperty(hidden = true)
    private Date lastLoginTime;

    @ApiModelProperty(hidden = true)
    private Long channelId;

    @ApiModelProperty("是否新用户(首次注册)")
    private Byte isNew;

    @ApiModelProperty(hidden = true)
    private String registerClient;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty(hidden = true)
    private Date createTime;

    @ApiModelProperty(hidden = true)
    private Date updateTime;

    @ApiModelProperty(hidden = true)
    private String channelName;

    @ApiModelProperty(hidden = true)
    private String levelStr;

    @ApiModelProperty("注册ip")
    private String regIp;

    @ApiModelProperty("邀请人")
    private Long inviteUserId;

    @ApiModelProperty("注册来源")
    private String registerChannel;

    @ApiModelProperty("当前选定城市")
    private String locationName;

    @ApiModelProperty("生日(精确到日) [注册不需传]")
    private Date birthday;

    @ApiModelProperty("用户个人信息地址 [注册不需传]")
    private String address;

    @ApiModelProperty("职业名称")
    private String jobTitle;

    @ApiModelProperty("公司名称")
    private String company;

    @ApiModelProperty("行业类型")
    private Long jobType;

    @ApiModelProperty("行业类型名称")
    private String jobTypeName;

    @ApiModelProperty("行业种类")
    private Long jobCategory;

    @ApiModelProperty("行业种类名称")
    private String jobCategoryName;

    @ApiModelProperty("所属家乡")
    private String hometownCode;

    @ApiModelProperty("家乡名称")
    private String hometownName;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty("用户标签id列表")
    private List<Long> userTagIds;

    @ApiModelProperty("情感状态")
    private Byte relationshipStatus;
}