package com.bxm.localnews.admin.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 通用的业务配置，具体模块的配置需要在对应的模块内创建properties和特定的前缀接收
 * @author liujia 2018/7/26 16:45
 */
@Component
@ConfigurationProperties("common.config")
public class BizConfigProperties {

    /**
     * 临时文件存储目录
     */
    private String tempDir;

    /**
     * 后端API域名
     */
    private String serverHost;

    /**
     * h5访问根路径
     */
    private String h5ServerHost;

    /**
     * 应用图标地址
     */
    private String appIconUrl;

    /**
     * 推广渠道链接H5地址
     */
    private String channelUrl;

    /**
     * APP下载H5地址
     */
    private String downloadUrl;

    /**
     * 活动分享链接
     */
    private String privilegeShareUrl;

    public String getPrivilegeShareUrl() {
        return privilegeShareUrl;
    }

    public void setPrivilegeShareUrl(String privilegeShareUrl) {
        this.privilegeShareUrl = privilegeShareUrl;
    }

    public String getTempDir() {
        return tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getServerHost() {
        return serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public String getH5ServerHost() {
        return h5ServerHost;
    }

    public void setH5ServerHost(String h5ServerHost) {
        this.h5ServerHost = h5ServerHost;
    }

    public String getAppIconUrl() {
        return appIconUrl;
    }

    public void setAppIconUrl(String appIconUrl) {
        this.appIconUrl = appIconUrl;
    }

    public String getChannelUrl() {
        return channelUrl;
    }

    public void setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}
