package com.bxm.localnews.admin.config.jwt;

import com.bxm.localnews.admin.service.AdminRoleService;
import com.bxm.localnews.admin.service.AdminUserService;
import com.bxm.localnews.admin.vo.AdminUser;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;


/**
 * 用户信息服务，Spring Security传递用户账号，获取完整的用户信息，用于后续的权限判断和密码匹配
 *
 * @author liujia 2018/3/28 15:31
 */
@Service
public class JwtUserDetailsServiceImpl implements UserDetailsService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    private AdminUserService adminUserService;

    private AdminRoleService adminRoleService;

    @Autowired
    public JwtUserDetailsServiceImpl(AdminUserService adminUserService, AdminRoleService adminRoleService) {
        this.adminUserService = adminUserService;
        this.adminRoleService = adminRoleService;
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (StringUtils.isBlank(username)) {
            throw new UsernameNotFoundException("用户账户为空");
        }
        AdminUser userInfo = adminUserService.getCacheUser(username);
        if (null == userInfo) {
            throw new UsernameNotFoundException("用户不存在");
        }
        userInfo.setAuthorities(adminRoleService.getUserAuthorities(userInfo.getId()));
        return userInfo;
    }
}
