package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.param.ActivityParam;
import com.bxm.localnews.admin.vo.Activity;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * Created by mars on 2018/3/16.
 */
public interface AdminActivityService {

    /**
     * 查询活动
     * @param param 活动参数
     * @return 分页结果
     */
    PageWarper<Activity> queryActivitys(ActivityParam param);

    /**
     * 批量更新活动状态
     * @param ids
     * @param state
     * @return 更新的行数
     */
    int updateActivityStateByIds(String[] ids, Byte state);

    /**
     * 获取活动详情
     * @param id
     * @return
     */
    Activity selectByPrimaryKey(Long id);

    /**
     * 更新活动信息
     * @param record
     * @return 更新的行数
     */
    int updateByPrimaryKeySelective(Activity record);

    /**
     * 插入活动信息
     * @param record
     * @return
     */
    int insertSelective(Activity record);
}
