package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.dto.AdminUserDTO;
import com.bxm.localnews.admin.param.AdminUserParam;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 管理员用户账号管理接口
 *
 * @author liujia 2018/8/7 22:48
 */
public interface AdminUserService {

    /**
     * 获取用户信息缓存
     *
     * @param userName 用户名
     * @return 用户信息，如果缓存中存在则直接返回缓存结果
     */
    AdminUser getCacheUser(String userName);

    /**
     * 清除用户信息缓存
     *
     * @param userName
     */
    void clearCacheUser(String userName);

    /**
     * 从token中的用户名获取用户信息
     *
     * @param token
     * @return
     */
    AdminUser getUserByToken(String token);

    /**
     * 更新用户密码信息
     *
     * @param param 更新参数
     * @return 更新结果
     */
    Json modifyPassword(AdminUserDTO param);

    /**
     * 更新用户密码信息
     *
     * @param param 更新参数
     * @return 更新结果
     */
    Json modifyPasswordByAdmin(AdminUserDTO param);

    /**
     * 移除缓存的用户信息
     *
     * @param userName 用户账号
     * @return 操作结果
     */
    Message removeCacheUser(String userName);

    Boolean editUserPassWord(AdminUser sysUser);

    /**
     * 用户列表
     *
     * @param adminUserParam
     * @return 分页结果
     */
    PageWarper<AdminUserDTO> queryAdminUsers(AdminUserParam adminUserParam);

    /**
     * 根据用户名查询用户信息
     *
     * @param username
     * @return
     */
    AdminUser selectByUsername(String username);

    /**
     * 添加用户信息
     *
     * @param user
     * @return
     */
    int upsert(AdminUserDTO user);

    /**
     * 更新用户信息
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(AdminUser record);
}
