package com.bxm.localnews.admin.service;

import java.util.List;

import com.bxm.localnews.admin.param.CommodityParam;
import com.bxm.localnews.admin.param.CommodityQueryParam;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 商品信息管理相关接口
 */
public interface CommodityService {

    /**
     * 分页获取商品信息
     *
     * @param param 查询参数
     * @return 分页结果集
     */
    PageWarper<CommodityBean> getCommodities(CommodityQueryParam param);

    /**
     * 保存商品信息
     *
     * @param param 商品编辑参数
     * @return 保存结果
     */
    Message save(CommodityParam param);

    /**
     * 变更商品信息
     *
     * @param param 商品编辑参数
     * @return 变更结果
     */
    Message modify(CommodityParam param);

    /**
     * 根据商品ID获取商品详情
     *
     * @param id 商品ID
     * @return 商品详情
     */
    CommodityBean get(long id);

    /**
     * 变更商品上下架状态。下架状态的商品不可参与活动
     *
     * @param id     商品ID
     * @param status 0：下架、1：上架
     * @return 变更结果
     */
    Message change(long id, int status);

    /**
     * 移除商品信息，如果商品已在活动中使用则提示不可删除
     *
     * @param id 商品ID
     * @return 移除结果
     */
    Message remove(long id);

    /**
     * 根据商品ID或商品名称获取匹配的前10条商品信息
     *
     * @param keyword 商品检索关键字(仅匹配商品ID和商品名称)
     * @return 匹配结果，如果为空返回空数组
     */
    List<CommodityBean> getTopMatchCommodities(String keyword);

    /**
     * 执行商品库存数量扣除
     *
     * @param commodityId 商品ID
     * @param num         扣除数量
     * @param privilegeId 活动id
     * @return 扣除结果与通知
     */
    Message execStoreDeduction(long commodityId, int num, long privilegeId);

    /**
     * 执行库存退回
     *
     * @param commodityId 商品ID
     * @param num         退回数量
     * @param privilegeId 活动id
     * @return 退回结果
     */
    Message execStoreReturned(long commodityId, int num, long privilegeId);

}
