package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.param.PrivilegeParam;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 优惠活动服务接口
 */
public interface PrivilegeService {

    /**
     * 新增优惠活动
     * 同时新增活动开启、活动结束的定时任务
     * @param param 活动录入参数
     * @return 新增结果
     */
    Message save(PrivilegeParam param);

    /**
     * 变更优惠互动
     * @param param 活动变更参数
     * @return 变更结果
     */
    Message modify(PrivilegeParam param);

    /**
     * 分页获取优惠活动信息
     * @param param 分页查询参数
     * @return 分页结果
     */
    PageWarper<PrivilegeBean> queryByPage(PrivilegeQueryParam param);

    /**
     * 根据优惠活动ID获取详情
     * @param id 活动ID
     * @return 活动详情
     */
    PrivilegeBean get(long id);

    /**
     * 移除活动信息
     * 如果活动处于上架状态，返回提示信息
     * 活动删除后，同时删除对应的定时任务
     * @param id 互动ID
     * @return 移除结果
     */
    Message remove(long id);

    /**
     * 变更活动上下架状态
     * 活动上架：启动相关定时任务
     * 活动下架：关闭相关定时任务
     * @param id     活动ID
     * @param status 活动状态
     * @return 变更结果
     */
    Message changeEnable(long id, int status);

    /**
     * 变更活动权重
     * @param id    活动ID
     * @param order 排序
     * @return 变更结果
     */
    Message changeOrder(long id, int order);

}
