package com.bxm.localnews.admin.service.impl;

import java.util.*;

import javax.annotation.Resource;

import com.bxm.localnews.admin.common.AppConst;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.domain.AdminChannelMapper;
import com.bxm.localnews.admin.dto.ChannelDTO;
import com.bxm.localnews.admin.dto.ChannelStatisDTO;
import com.bxm.localnews.admin.param.ChannelParam;
import com.bxm.localnews.admin.service.AdminChannelService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2017/12/23.
 */

@Service
@RefreshScope
public class AdminChannelServiceImpl implements AdminChannelService {

    private final static Logger logger = LoggerFactory.getLogger(AdminChannelServiceImpl.class);

    @Resource
    private AdminChannelMapper adminChannelMapper;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Override
    public PageWarper<ChannelDTO> queryChannelDTOs(ChannelParam param) {
        Preconditions.checkArgument(param != null);

        PageWarper<ChannelDTO> pageWarper = new PageWarper<>(adminChannelMapper.queryChannelDTOByPageSize(param));
        List<ChannelDTO> channelDTOS = pageWarper.getList();

        String channelUrl = bizConfigProperties.getChannelUrl();
        channelDTOS.forEach(channelDTO ->
                channelDTO.setGeneralizeUrl(channelUrl + channelDTO.getCode())
        );

        return pageWarper;
    }

    @Override
    public Json insertSelective(Channel channel) {
        channel.setCreateTime(new Date());
        channel.setState(AppConst.STATE_USE);
        channel.setType(Byte.parseByte(Channel.TYPE_1));
        int i = this.adminChannelMapper.insertSelective(channel);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult("操作失败");
    }

    @Override
    public Json updateBySelective(Channel channel) {
        int i = this.adminChannelMapper.updateByPrimaryKeySelective(channel);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genSuccessResult("操作失败");
    }

    @Override
    public int countByCode(String code) {
        return this.adminChannelMapper.countByCode(code);
    }

    @Override
    public Json changeState(Long channelId, String state) {
        Channel channel = this.adminChannelMapper.selectByPrimaryKey(channelId);
        if (channel == null) {
            return ResultUtil.genFailedResult("操作失败,无该功能");
        }
        channel.setState(Byte.valueOf(state));
        int i = this.adminChannelMapper.updateByPrimaryKeySelective(channel);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult("系统异常,请联系管理员");
    }

    @Override
    public PageWarper<ChannelStatisDTO> channelStatis(ChannelParam param) {
        Preconditions.checkArgument(param != null);

        PageWarper<ChannelStatisDTO> pageWarper = new PageWarper<>(this.adminChannelMapper
                .queryChannelStatisDTOByPageSize(param));
        List<ChannelStatisDTO> ret = pageWarper.getList();

        Map<String, Integer> map1 = this.getCacheNum(param);
        if (CollectionUtils.isNotEmpty(ret)) {
            for (ChannelStatisDTO model : ret) {
                model.setOpenCount(map1.get(model.getCode()) == null ? "0" : map1.get(model.getCode()) + "");
            }
        }

        return pageWarper;
    }

    @Override
    public Channel selectById(Long id) {
        return this.adminChannelMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<Channel> selectRegistChannelList() {
        return this.adminChannelMapper.selectRegistChannel();
    }

    private Map<String, Integer> getCacheNum(ChannelParam channelParam) {
        String begin = channelParam.getBeginTime();
        String end = channelParam.getEndTime();
        if (StringUtils.isEmpty(begin) || StringUtils.isEmpty(end)) {
            throw new RuntimeException("参数错误");
        }

        Date beginDate = DateUtils.parseDateNonStrict(begin);

        int days = this.getIntervalDays(beginDate, DateUtils.parseDateNonStrict(end));
        days = days + 1;
        if (days <= 0) {
            throw new RuntimeException("选择时间范围有误,请重新选择");
        }
        Map<String, Integer> map1 = Maps.newHashMap();
        for (int i = 0; i < days; i++) {
            String newBeginDate = DateUtils.formatDate(DateUtils.addField(beginDate, Calendar.DATE, i));
            String nkey = "channel_web_stat:" + newBeginDate;

            Set<String> keySet = this.redisHashMapAdapter.keys(RedisKeyGenerator.build(nkey));
            for (String subKey : keySet) {
                if (map1.containsKey(subKey)) {
                    Integer num = map1.get(subKey) +
                            NumberUtils.parseToInt(this.redisHashMapAdapter.get(RedisKeyGenerator.build(nkey), subKey, String.class));
                    map1.put(subKey, num);
                } else {
                    map1.put(subKey, NumberUtils.parseToInt(this.redisHashMapAdapter.get(RedisKeyGenerator.build(nkey), subKey, String.class)));
                }
            }
        }
        return map1;
    }

    public int getIntervalDays(Date fDate, Date oDate) {
        if (null == fDate || null == oDate) {
            return -1;
        }
        long intervalMilli = oDate.getTime() - fDate.getTime();
        return (int) (intervalMilli / (24 * 60 * 60 * 1000));
    }

}
