package com.bxm.localnews.admin.service.impl;

import java.util.List;

import com.bxm.localnews.admin.domain.AdminMenuMapper;
import com.bxm.localnews.admin.dto.AdminMenuDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.service.AdminMenuService;
import com.bxm.localnews.admin.vo.AdminMenu;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2018/10/15 20:28
 * @desc
 */
@Service("adminMenuService")
public class AdminMenuServiceImpl implements AdminMenuService {

    private AdminMenuMapper adminMenuMapper;

    @Autowired
    public AdminMenuServiceImpl(AdminMenuMapper adminMenuMapper) {
        this.adminMenuMapper = adminMenuMapper;
    }

    @Override
    public List<AdminMenuDTO> getMenusByRoleId(Integer roleId) {

        return this.adminMenuMapper.getMenusByRoleId(roleId);
    }

    @Override
    public List<AdminMenuDTO> getMenusByRole(Long roleId) {
        return this.adminMenuMapper.getMenusByRole(roleId);
    }

    @Override
    public List<AdminMenuDTO> getAllMenu() {
        return this.adminMenuMapper.getAllMenu();
    }

    @Override
    public AdminMenu selectByPrimaryKey(Integer menuId) {
        return this.adminMenuMapper.selectByPrimaryKey(menuId);
    }

    @Override
    public List<AdminMenu> getParentMenus() {
        return this.adminMenuMapper.getParentMenus();
    }

    @Override
    public int upsert(AdminMenu menu) {
        return this.adminMenuMapper.upsert(menu);
    }

    @Override
    public int deleteByPrimaryKey(Integer menuid) {
        return this.adminMenuMapper.deleteByPrimaryKey(menuid);
    }

    @Override
    public List<MenuDTO> getMenusAndPermsByRoleId(Integer roleId) {
        return this.adminMenuMapper.getMenusAndPermsByRoleId(roleId);
    }
}
