package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.domain.AdminUserAddressBookMapper;
import com.bxm.localnews.admin.param.AddressBookParam;
import com.bxm.localnews.admin.service.AdminUserAddressBookService;
import com.bxm.localnews.admin.vo.UserAddressBook;
import com.bxm.newidea.component.vo.PageWarper;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2018/10/16 20:00
 * @desc
 */
@Service
public class AdminUserAddressBookServiceImpl implements AdminUserAddressBookService {

    private AdminUserAddressBookMapper adminUserAddressBookMapper;

    @Autowired
    public AdminUserAddressBookServiceImpl(AdminUserAddressBookMapper adminUserAddressBookMapper) {
        this.adminUserAddressBookMapper = adminUserAddressBookMapper;
    }

    @Override
    public PageWarper<UserAddressBook> queryUserAddressBooks(AddressBookParam addressBookParam) {
        return new PageWarper<>(adminUserAddressBookMapper.queryUserAddressBooByPageSize(addressBookParam));
    }
}
