package com.bxm.localnews.admin.service.impl;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.PrivilegeStatusEnum;
import com.bxm.localnews.admin.domain.PrivilegeAreaMapper;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.param.PrivilegeParam;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.service.CommodityService;
import com.bxm.localnews.admin.service.MerchantService;
import com.bxm.localnews.admin.service.PrivilegeService;
import com.bxm.localnews.admin.service.ShortLinkService;
import com.bxm.localnews.admin.task.PrivilegeFinishTask;
import com.bxm.localnews.admin.task.PrivilegeStartTask;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.localnews.admin.vo.PrivilegeAreaBean;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class PrivilegeServiceImpl extends BaseService implements PrivilegeService {

    private PrivilegeMapper privilegeMapper;

    private ScheduleJobService scheduleJobService;

    private AliyunOSSService aliyunOSSService;

    private CommodityService commodityService;

    private HttpClientService httpClientService;

    private PrivilegeAreaMapper privilegeAreaMapper;

    private MerchantService merchantService;

    private ShortLinkService shortLinkService;

    private BizConfigProperties bizConfigProperties;

    @Autowired
    public PrivilegeServiceImpl(PrivilegeMapper privilegeMapper, PrivilegeAreaMapper privilegeAreaMapper,
                                ScheduleJobService scheduleJobService, AliyunOSSService aliyunOSSService,
                                CommodityService commodityService, HttpClientService httpClientService,
                                ShortLinkService shortLinkService, BizConfigProperties bizConfigProperties) {
        this.privilegeMapper = privilegeMapper;
        this.scheduleJobService = scheduleJobService;
        this.aliyunOSSService = aliyunOSSService;
        this.commodityService = commodityService;
        this.httpClientService = httpClientService;
        this.privilegeAreaMapper = privilegeAreaMapper;
        this.shortLinkService = shortLinkService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    public Message save(PrivilegeParam param) {
        PrivilegeBean entity = convert(param);
        entity.setShareBgUrl(param.getThumbnailUrl());
        entity.setDeleteFlag(0);
        entity.setAddTime(new Date());
        //活动默认进行中状态，于181212改
        entity.setStatus(PrivilegeStatusEnum.BEGIN.getCode());

//        //从商品库存中扣除活动发放的奖品数量 18/12/11新需求改动
//        Message message = commodityService.execStoreDeduction(entity.getCommodityId(), entity.getPrizeNum(), entity.getId());
//
//        if (message.isSuccess()) {
//            //设置调度任务
//            setScheduleJob(entity);
//            //保存投放区域
//            saveAreaRelation(param, entity.getId());
//            privilegeMapper.insert(entity);
//        }
        saveAreaRelation(param, entity.getId());
        privilegeMapper.insert(entity);
        return Message.build(1);
    }

    /**
     * 设置活动相关的定时调度任务，负责在活动开启变更状态，在活动结束时抽奖、通知等
     * 设置任务前，先移除旧的定时任务
     * @param entity 活动实体信息
     */
    private void setScheduleJob(PrivilegeBean entity) {
        PrivilegeStartTask startTask = new PrivilegeStartTask();
        String startJobId = startTask.getJobName() + "_" + entity.getId();

        startTask.setJobName(startJobId);
        startTask.setStartTime(entity.getStartTime());
        startTask.addParam("id", entity.getId());

        if (scheduleJobService.getJob(startTask.getJobName(), startTask.getGroup()) != null) {
            scheduleJobService.remove(startTask.getJobName(), startTask.getGroup());
        }
        scheduleJobService.addSimpleJob(startTask);

        PrivilegeFinishTask endTask = new PrivilegeFinishTask();
        String endJobId = endTask.getJobName() + "_" + entity.getId();
        endTask.setJobName(endJobId);
        endTask.setStartTime(entity.getEndTime());
        endTask.addParam("id", entity.getId());

        if (scheduleJobService.getJob(endTask.getJobName(), endTask.getGroup()) != null) {
            scheduleJobService.remove(endTask.getJobName(), endTask.getGroup());
        }
        scheduleJobService.addSimpleJob(endTask);
    }

    private void setFinishJob(PrivilegeBean entity) {
        PrivilegeFinishTask endTask = new PrivilegeFinishTask();
        String endJobId = endTask.getJobName() + "_" + entity.getId();
        endTask.setJobName(endJobId);
        endTask.setStartTime(entity.getEndTime());
        endTask.addParam("id", entity.getId());

        if (scheduleJobService.getJob(endTask.getJobName(), endTask.getGroup()) != null) {
            scheduleJobService.remove(endTask.getJobName(), endTask.getGroup());
        }
        scheduleJobService.addSimpleJob(endTask);
    }

    /**
     * 保存活动的投放区域信息
     * @param param 新增、编辑参数
     * @param id    活动ID
     */
    private void saveAreaRelation(PrivilegeParam param, long id) {
        //移除投放区域
        privilegeAreaMapper.deleteByPrivilegeId(id);
        if (param.getGlobalFlag() == 1) {
            return;
        }
        if (StringUtils.isNotBlank(param.getAreaCodes())) {
            String[] relationCodeArray = StringUtils.split(param.getAreaCodes(), ",");

            new BatchHelper<PrivilegeAreaMapper, String>(PrivilegeAreaMapper.class, relationCodeArray) {
                @Override
                protected int invoke(String element) {
                    PrivilegeAreaBean privilegeAreaBean = new PrivilegeAreaBean();
                    privilegeAreaBean.setId(nextId());
                    privilegeAreaBean.setAreaCode(element);
                    privilegeAreaBean.setPrivilegeId(id);
                    return this.mapper.insert(privilegeAreaBean);
                }
            };
        }

    }

    @Override
    public Message modify(PrivilegeParam param) {
        Message message = Message.build(1);

        PrivilegeBean entity = convert(param);
        //保存投放区域
        saveAreaRelation(param, entity.getId());
        privilegeMapper.updateByPrimaryKey(entity);
        return message;
    }

    private PrivilegeBean convert(PrivilegeParam param) {
        PrivilegeBean entity = new PrivilegeBean();
        BeanUtils.copyProperties(param, entity);

        if (param.getId() <= 0) {
            entity.setId(nextId());
        }

        //根据商品ID获取商户ID
        if (param.getCommodityId() > 0) {
            CommodityBean commodityDetail = commodityService.get(param.getCommodityId());
            if (null != commodityDetail) {
                entity.setMerchantId(commodityDetail.getMechantId());
            } else {
                logger.error("商品[{}]已被删除，关联活动的商品不允许删除", param.getCommodityId());
            }
        }

        return entity;
    }

    @Override
    public PageWarper<PrivilegeBean> queryByPage(PrivilegeQueryParam param) {
        Preconditions.checkArgument(param != null);
        PageWarper<PrivilegeBean> pageWarper = new PageWarper<PrivilegeBean>(privilegeMapper.queryByPageSize(param));
        pageWarper.getList().forEach(privilegeBean -> {
            privilegeBean.setPrivilegeAreas(privilegeAreaMapper.getPrivilegeAreas(privilegeBean.getId()));
        });
        pageWarper.getList().forEach(privilegeBean -> {
            privilegeBean.setShortUrl4QRCode(
                    shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId() + "&posterFlag=chook"));
        });
        pageWarper.getList().forEach(privilegeBean -> {
            privilegeBean.setShortUrl4Poster(
                    shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId()));
        });
        return pageWarper;
    }

    @Override
    public PrivilegeBean get(long id) {
        PrivilegeBean entity = privilegeMapper.selectByPrimaryKey(id);

        entity.setPrivilegeAreas(privilegeAreaMapper.getPrivilegeAreas(entity.getId()));
        return entity;
    }

    @Override
    public Message remove(long id) {
        PrivilegeBean entity = get(id);
        if (entity.getStatus() != PrivilegeStatusEnum.FINISH.getCode()) {
            return Message.build(false).setMessage("活动当前处于未结束状态，不可删除");
        }
        //删除定时任务
        Message message = Message.build(privilegeMapper.deleteByPrimaryKey(id));
        if (message.isSuccess()) {
            removeTask(id);
        }
        return message;
    }

    private void removeTask(long privilegeId) {
        PrivilegeStartTask startTask = new PrivilegeStartTask();
        String startJobId = startTask.getJobName() + "_" + privilegeId;
        scheduleJobService.remove(startTask.getJobName(), startTask.getGroup());

        PrivilegeFinishTask endTask = new PrivilegeFinishTask();
        String endJobId = endTask.getJobName() + "_" + privilegeId;
        scheduleJobService.remove(endTask.getJobName(), endTask.getGroup());
    }

    @Override
    public Message changeEnable(long id, int status) {
        privilegeMapper.changeEnable(id, status);
        if (status == 0) {
            removeTask(id);
        } else if (status == 1) {
            PrivilegeBean entity = get(id);
//            setScheduleJob(entity);
        }
        return Message.build(true);
    }

    @Override
    public Message changeOrder(long id, int order) {
        privilegeMapper.changeOrder(id, order);
        return Message.build(true);
    }

}
