package com.bxm.localnews.admin.config;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 无权访问时的处理方案
 * @author liujia 2018/4/22 22:13
 */
public class CustomAccessDeniedHandler implements AccessDeniedHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(CustomAccessDeniedHandler.class);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!response.isCommitted()) {
            LOGGER.info("用户[{}]无权访问指定的路径：{}", WebUtils.getCurrentUserId(), request.getRequestURI());

            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");

            Json<String> result = Json.build(HttpStatus.FORBIDDEN.value(), "无权访问");
            response.getWriter().write(JSON.toJSONString(result));
            response.getWriter().flush();
        }
    }
}
