package com.bxm.localnews.admin.config.jwt;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 验证未通过时的切入点
 * @author liujia 2018/3/28 15:18
 */
public class JwtAuthenticationEntryPoint extends LoginUrlAuthenticationEntryPoint {


    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthenticationEntryPoint.class);


    /**
     * @param loginFormUrl URL where the login page can be found. Should either be
     *                     relative to the web-app context path (include a leading {@code /}) or an absolute
     *                     URL.
     */
    public JwtAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        LOGGER.info("request uri:{}", request.getRequestURI());

        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");

        Json<String> result = Json.build(HttpStatus.UNAUTHORIZED.value(), "需要登录后访问");
        response.getWriter().write(JSON.toJSONString(result));
        response.getWriter().flush();
    }
}
