package com.bxm.localnews.admin.constant;

/**
 * 审批结果
 */
public enum ApproveResultEnum {
    /**
     * 待审核
     */
    INIT(0),
    /**
     * 审批通过
     */
    OK(1),
    /**
     * 审批拒绝
     */
    REJECT(2);

    private int code;

    ApproveResultEnum(int code) {
        this.code = code;
    }

    public static ApproveResultEnum get(int code) {
        for (ApproveResultEnum result : ApproveResultEnum.values()) {
            if (result.getCode() == code) {
                return result;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
