package com.bxm.localnews.admin.service;

import java.util.List;

import com.bxm.localnews.admin.dto.AdminMenuDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.vo.AdminMenu;

/**
 * @author zhaoyadong
 */
public interface AdminMenuService {

    /**
     * 根据角色获取菜单
     * @param roleId
     * @return 菜单列表
     */
    List<AdminMenuDTO> getMenusByRoleId(Integer roleId);

    /**
     * 根据角色获取菜单
     * @param roleId
     * @return 菜单列表
     */
    List<AdminMenuDTO> getMenusByRole(Long roleId);

    /**
     * 获取所有菜单列表
     * @return 菜单列表
     */
    List<AdminMenuDTO> getAllMenu();

    /**
     * 获取菜单信息
     * @param menuId
     * @return
     */
    AdminMenu selectByPrimaryKey(Integer menuId);

    /**
     * 获取父级菜单
     * @return
     */
    List<AdminMenu> getParentMenus();

    /**
     * 更新菜单信息
     * @param menu
     * @return 更新的行数
     */
    int upsert(AdminMenu menu);

    /**
     * 根据菜单id删除菜单
     * @param menuid
     * @return
     */
    int deleteByPrimaryKey(Integer menuid);

    /**
     * 根据角色id获取菜单列表
     * @param roleId
     * @return
     */
    List<MenuDTO> getMenusAndPermsByRoleId(Integer roleId);
}
