package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.param.NewsAddParam;
import com.bxm.localnews.admin.param.NewsParam;
import com.bxm.localnews.admin.param.NewsUpdateParam;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.Date;
import java.util.List;

/**
 * @author zhaoyadong 2018/10/16 9:15
 * @desc
 */
public interface AdminNewsService {

    /**
     * 查询新闻
     * @param newsParam
     * @return 分页结果
     */
    PageWarper<News> queryNews(NewsParam newsParam);

    /**
     * 更新新闻
     * @param news
     * @return
     */

    int updateByPrimaryKeySelective(News news);

    /**
     * 更新新闻状态
     * @param ids 新闻的id数组
     * @param status 状态
     * @return
     */
    int updateNewsStatusByIds(String[] ids, Byte status);

    /**
     * 获取新闻详情
     * @param id
     * @return
     */
    News selectByPrimaryKey(Long id);

    Json addNews(NewsAddParam newsParam);

    Json updateNews(NewsUpdateParam newsUpdateParam);

    List<NewsKind> getAllKind();

    /**
     * 设置标签
     * @param showLevelEnum
     * @param id
     * @return
     */
    Json settingLevel(ShowLevelEnum showLevelEnum,Long id);
}
