package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.param.TaskParam;
import com.bxm.localnews.admin.vo.TaskBean;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 日常任务和新手任务相关管理服务接口
 */
public interface TaskService {

    /**
     * 变更任务状态
     * @param state   任务状态
     * @param taskIds 任务ID列表
     * @return 变更结果
     */
    Message modifyTaskStatus(Byte state, String... taskIds);

    /**
     * 分页查询任务信息
     * @param param 查询参数
     * @return 分页结果
     */
    PageWarper<TaskBean> queryTaskByPage(TaskParam param);

    /**
     * 获取任务详情
     * @param taskId 任务ID
     * @return 任务详细信息
     */
    TaskBean getTaskById(Long taskId);

}
