package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.domain.AdminNewsInformMapper;
import com.bxm.localnews.admin.param.NewsInformParam;
import com.bxm.localnews.admin.service.AdminNewsInformService;
import com.bxm.localnews.admin.vo.NewsInform;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author zhaoyadong 2018/10/16 10:31
 * @desc
 */
@Service
public class AdminNewsInformServiceImpl implements AdminNewsInformService {

    private AdminNewsInformMapper adminNewsInformMapper;

    private BizConfigProperties bizConfigProperties;

    @Autowired(required = false)
    public AdminNewsInformServiceImpl(AdminNewsInformMapper adminNewsInformMapper, BizConfigProperties bizConfigProperties) {
        this.adminNewsInformMapper = adminNewsInformMapper;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    public PageWarper<NewsInform> queryNewsInforms(NewsInformParam newsInformParam) {
        Preconditions.checkArgument(newsInformParam != null);

        PageWarper<NewsInform> pageWarper = new PageWarper<>(this.adminNewsInformMapper
                .queryNewsInformByPageSize(newsInformParam));

        List<NewsInform> newsInformList = pageWarper.getList();

        String serverHost = bizConfigProperties.getServerHost();
        for (NewsInform NewsInform : newsInformList) {
            NewsInform.setLinkUrl(serverHost + "/newsDetail.html?newsId=" + NewsInform.getNewsId() + "&userId=" + "&type=1");
        }

        return pageWarper;
    }

    @Override
    public int updateByMap(Map<String, Object> map) {
        return this.adminNewsInformMapper.updateByMap(map);
    }
}
