package com.bxm.localnews.admin.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.MarketingActivitiesDeliveryTypeEnum;
import com.bxm.localnews.admin.constant.NewsAreaRelationTypeEnum;
import com.bxm.localnews.admin.constant.NewsStatusEnum;
import com.bxm.localnews.admin.domain.*;
import com.bxm.localnews.admin.dto.ESNewsContentDTO;
import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.seq.NewsSeqComponent;
import com.bxm.localnews.admin.service.AdminNewsService;
import com.bxm.localnews.admin.service.CommonTagService;
import com.bxm.localnews.admin.service.NewsElasticService;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.admin.vo.*;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author zhaoyadong 2018/10/16 9:22
 * @desc
 */
@Service
public class AdminNewsServiceImpl implements AdminNewsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private NewsSeqComponent newsSeqComponent;

    private NewsDeliveryAreaMapper newsDeliveryAreaMapper;

    private NewsKindMapper kindMapper;


    private CommonTagService commonTagService;

    private NewsTagMapper newsTagMapper;

    private NewsStatisticsMapper newsStatisticsMapper;

    private AdminNewsMapper adminNewsMapper;

    private BizConfigProperties bizConfigProperties;

    private NewsElasticService newsElasticService;

    private NewsSyncService newsSyncService;

    private AreaCodeMapper areaCodeMapper;

    @Autowired(required = false)
    public AdminNewsServiceImpl(AdminNewsMapper adminNewsMapper, BizConfigProperties bizConfigProperties,
                                NewsElasticService newsElasticService,
                                NewsSeqComponent newsSeqComponent,NewsDeliveryAreaMapper newsDeliveryAreaMapper,
                                NewsKindMapper kindMapper,
                                CommonTagService commonTagService,NewsTagMapper newsTagMapper,
                                NewsStatisticsMapper newsStatisticsMapper,
                                NewsSyncService newsSyncService,
                                AreaCodeMapper areaCodeMapper) {
        this.adminNewsMapper = adminNewsMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.newsElasticService = newsElasticService;
        this.newsSeqComponent = newsSeqComponent;
        this.newsDeliveryAreaMapper = newsDeliveryAreaMapper;
        this.kindMapper = kindMapper;
        this.commonTagService = commonTagService;
        this.newsTagMapper = newsTagMapper;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsSyncService = newsSyncService;
        this.areaCodeMapper = areaCodeMapper;
    }

    @Override
    public PageWarper<News> queryNews(NewsParam newsParam) {
        logger.info("NewsParam:{}",JSON.toJSON(newsParam));
        PageWarper<News> pageWarper = new PageWarper<>(adminNewsMapper.queryNewsByPageSize(newsParam));
        List<News> newsList = pageWarper.getList();

        String serverHost = bizConfigProperties.getServerHost();
        for (News news : newsList) {
            if (news.getType() == 1 || news.getType() == 3) {
                news.setLinkUrl(serverHost + "/newsDetail.html?newsId=" + news.getId() + "&userId=" + "&type=" + news.getType());
            }
        }
        return pageWarper;
    }

    @Override
    public int updateByPrimaryKeySelective(News news) {
        return this.adminNewsMapper.updateByPrimaryKeySelective(news);
    }

    @Override
    public int updateNewsStatusByIds(String[] ids, Byte status) {
        return this.adminNewsMapper.updateNewsStatusByIds(ids, status);
    }

    @Override
    public News selectByPrimaryKey(Long id) {
        News news = this.adminNewsMapper.selectByPrimaryKey(id);
        if(news==null){
            return null;
        }
        logger.debug("新闻详情es开始拉取 ");
        ResponseEntity<List<ESNewsContentDTO>> responseEntity = newsElasticService.multipleGet(new Long[]{news.getId()});
        if(responseEntity==null||responseEntity.getStatusCode().isError()||responseEntity.getBody().isEmpty()){
            logger.debug("新闻详情es拉取失败:{}", responseEntity.getBody());

           // return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "获取详情时新闻缺失");
            return null;
        }
        news.setContent(responseEntity.getBody().get(0).getContent());
        logger.debug("新闻详情拉取完成：{}",responseEntity.getBody());
        String serverHost = bizConfigProperties.getServerHost();
        if (news.getType() == 1 || news.getType() == 3) {
            news.setLinkUrl(serverHost + "/newsDetail.html?newsId=" + news.getId() + "&userId=" + "&type=" + news.getType());
        }

        return news;
    }

    //TODO
    //运营设置的热标签 ，距离展示时间 24小时后失效
    @Override
    @Transactional
    public Json addNews(NewsAddParam newsParam) {
        News news = new News();
        news.setId(newsSeqComponent.getNewsId());
        news.setTitle(newsParam.getTitle());
        news.setAddTime(Calendar.getInstance().getTime());
        news.setAddress("null");
        news.setTop((byte)0);
        news.setHot((byte)0);
        news.setType((byte)1);
        news.setViews(100l);
        news.setAuthor(newsParam.getAuthor());
        news.setKindId(newsParam.getKindId());

        if(StringUtils.isNotBlank(newsParam.getCoverUrl())) {
            news.setImgUrl(JSON.toJSONString(newsParam.getCoverUrl().split(",")));
        }
        news.setIssueTime(newsParam.getIssueTime());
        news.setPublishTime(newsParam.getPublishTime());
        news.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
        news.setDeliveryType(newsParam.getDeliveryType());
        if(StringUtils.isNotBlank(newsParam.getShowLevels())){
            List<String> list = Arrays.asList(newsParam.getShowLevels().split(","));
            Collections.sort(list);
            //值越小 优先级越高 优先级最高的为当前展示等级（既标签）
            news.setShowLevel(Integer.parseInt(list.get(0)));
            news.setShowLevelDetail(StringUtils.join(list,","));
        }else{
            news.setShowLevel(ShowLevelEnum.NORMAL.getCode());
            news.setShowLevelDetail(ShowLevelEnum.NORMAL.getCode().toString());
        }
        //投放为区域型
        if(newsParam.getDeliveryType()== MarketingActivitiesDeliveryTypeEnum.AREA.getCode()) {
            if (StringUtils.isNotBlank(newsParam.getAreaCodes())) {
                List<AreaCode> areaCodeList = new ArrayList<>();
                for(String code:newsParam.getAreaCodes().split(",")){
                    NewsDeliveryArea area = new NewsDeliveryArea();
                    AreaCode areaCode = areaCodeMapper.findByCode(code);
                    area.setAreaCode(code);
                    area.setAreaName(areaCode.getAreaName());
                    area.setCreateTime(Calendar.getInstance().getTime());
                    area.setBusinessId(news.getId());
                    area.setRelationType(NewsAreaRelationTypeEnum.NEWS.getCode());
                    newsDeliveryAreaMapper.save(area);
                    areaCodeList.add(areaCode);
                }
                news.setAreaDetail(JSON.toJSONString(areaCodeList));
                adminNewsMapper.save(news);
            }else{
                return ResultUtil.genFailedResult("投放区域入参错误");
            }
        }else{
            adminNewsMapper.save(news);
        }

        ResponseEntity<List<Keyword>> responseEntity = newsSyncService.save(news.getTitle(),newsParam.getContent());
        if(responseEntity.getStatusCode().isError()){
            return ResultUtil.genFailedResult("同步分词服务出现错误");
        }
        List<Keyword> tagList = responseEntity.getBody();
        for(Keyword keyword:tagList){
                    NewsTag newsTag = new NewsTag();
                    newsTag.setAddTime(Calendar.getInstance().getTime());
                    newsTag.setName(keyword.getName());
                    newsTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                    newsTag.setWeight(keyword.getTfidfvalue());
                    newsTag.setNewsId(news.getId());
                    newsTag.setTagId(commonTagService.saveAndGetTag(keyword.getName()));
                    newsTagMapper.save(newsTag);
        }
        List<NewsKind> kindList =kindMapper.selectAllKinds();
        Optional<NewsKind> newsKind = kindList.stream().filter(kind -> kind.getId().intValue()==news.getKindId()).findFirst();
        if(newsKind.isPresent()){
            NewsTag kindTag = new NewsTag();
            kindTag.setAddTime(Calendar.getInstance().getTime());
            kindTag.setName(newsKind.get().getName());
            kindTag.setTagType(NewsTagTypeEnum.CHANNEL_TAG.getCode());
            kindTag.setNewsId(news.getId());
            kindTag.setWeight(0D);
            kindTag.setTagId(commonTagService.saveAndGetTag(newsKind.get().getName()));
            newsTagMapper.save(kindTag);
        }
        if(newsParam.getDeliveryType()== MarketingActivitiesDeliveryTypeEnum.AREA.getCode()){
            for(String area:newsParam.getAreaCodes().split(",")){
                NewsDeliveryArea newsDeliveryArea = new NewsDeliveryArea();
                newsDeliveryArea.setRelationType(NewsAreaRelationTypeEnum.NEWS.getCode());
                newsDeliveryArea.setBusinessId(news.getId());
                newsDeliveryArea.setAreaCode(area);
                newsDeliveryArea.setCreateTime(Calendar.getInstance().getTime());
                newsDeliveryAreaMapper.save(newsDeliveryArea);
            }
        }
        NewsStatistics newsStatistics = new NewsStatistics();
        newsStatistics.setAddTime(Calendar.getInstance().getTime());
        newsStatistics.setClicks(0);
        newsStatistics.setCollects(0);
        newsStatistics.setComments(0);
        newsStatistics.setRecommends(0);
        newsStatistics.setActiveViews(0);
        newsStatistics.setShares(0);
        newsStatistics.setNewClicks(new Random().nextInt(4500) + 500);
        newsStatistics.setNewsId(news.getId());
        newsStatisticsMapper.save(newsStatistics);
        NewsParam param = new NewsParam();
        param.setId(news.getId());
        param.setTitle(news.getTitle());
        param.setContent(newsParam.getContent());
        param.setIssueTime(newsParam.getPublishTime());
        newsElasticService.save(param);
        return ResultUtil.genSuccessResult();
    }

    @Transactional
    public Json updateNews(NewsUpdateParam newsUpdateParam){
        News news = adminNewsMapper.selectByPrimaryKey(newsUpdateParam.getId());
        if(news==null){
            return ResultUtil.genFailedResult("新闻不存在");
        }
        News param = new News();
        param.setId(news.getId());
        param.setTitle(newsUpdateParam.getTitle());
        param.setAuthor(newsUpdateParam.getAuthor());
        param.setKindId(newsUpdateParam.getKindId());
        if(StringUtils.isNotBlank(newsUpdateParam.getCoverUrl())) {
            param.setImgUrl(JSON.toJSONString(newsUpdateParam.getCoverUrl().split(",")));
        }
        param.setIssueTime(newsUpdateParam.getIssueTime());
        param.setPublishTime(newsUpdateParam.getPublishTime());
        if(news.getStatus()==NewsStatusEnum.UNPUBLISHED.getCode()){
            if(StringUtils.isNotBlank(newsUpdateParam.getAreaCodes())){
                param.setDeliveryType(newsUpdateParam.getDeliveryType());
                List<AreaCode> areaCodeList = new ArrayList<>();
                newsDeliveryAreaMapper.deleteByBusinessId(news.getId(),NewsAreaRelationTypeEnum.NEWS.getCode());
                for(String code:newsUpdateParam.getAreaCodes().split(",")){
                    NewsDeliveryArea area = new NewsDeliveryArea();
                    AreaCode areaCode = areaCodeMapper.findByCode(code);
                    area.setAreaCode(code);
                    area.setCreateTime(Calendar.getInstance().getTime());
                    area.setAreaName(areaCode.getAreaName());
                    area.setBusinessId(news.getId());
                    area.setRelationType(NewsAreaRelationTypeEnum.NEWS.getCode());
                    newsDeliveryAreaMapper.save(area);
                    areaCodeList.add(areaCode);
                }
                param.setAreaDetail(JSON.toJSONString(areaCodeList));
            }
        }
        if(StringUtils.isNotBlank(newsUpdateParam.getShowLevels())){
            List<String> list = Arrays.asList(newsUpdateParam.getShowLevels().split(","));
            Collections.sort(list);
            //值越小 优先级越高 优先级最高的为当前展示等级（既标签）
            param.setShowLevel(Integer.parseInt(list.get(0)));
            param.setShowLevelDetail(StringUtils.join(list,","));
        }else {
            param.setShowLevel(ShowLevelEnum.NORMAL.getCode());
            param.setShowLevelDetail(ShowLevelEnum.NORMAL.getCode().toString());
        }
        adminNewsMapper.updateByPrimaryKeySelective(param);
        if(!StringUtils.equals(newsUpdateParam.getContent(),news.getContent())){
            NewsParam contentParam = new NewsParam();
            contentParam.setId(news.getId());
            contentParam.setTitle(news.getTitle());
            contentParam.setContent(newsUpdateParam.getContent());
            contentParam.setIssueTime(newsUpdateParam.getPublishTime());
            newsElasticService.save(contentParam);
        }

        return ResultUtil.genSuccessResult();
    }

    @Override
    public List<NewsKind> getAllKind() {
        List<NewsKind> list = kindMapper.selectAllKinds();
        return list;
    }




    @Override
    public Json settingLevel(ShowLevelEnum showLevelEnum, Long id) {
        News news = adminNewsMapper.selectByPrimaryKey(id);
        if(news==null){
            return ResultUtil.genFailedResult("新闻不存在");
        }
        News param = new News();
        if(StringUtils.isNotBlank(news.getShowLevelDetail())){
            String[] levels = StringUtils.split(news.getShowLevelDetail(),",");
            List<String> levelList = new ArrayList<>(Arrays.asList(levels));
            if(!levelList.contains(showLevelEnum.getCode()+"")){
                levelList.add(showLevelEnum.getCode()+"");
            }
            Collections.sort(levelList);
            param.setId(id);
            param.setShowLevel(Integer.parseInt(levelList.get(0)));
            param.setShowLevelDetail(StringUtils.join(levelList,","));
            adminNewsMapper.updateByPrimaryKeySelective(param);
        }else{
            param.setId(id);
            param.setShowLevel(showLevelEnum.getCode());
            param.setShowLevelDetail(showLevelEnum.getCode()+"");
            adminNewsMapper.updateByPrimaryKeySelective(param);
        }
        return ResultUtil.genSuccessResult();
    }


}
