package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.domain.AdminVideoFetchKeywordMapper;
import com.bxm.localnews.admin.service.AdminVideoFetchKeywordService;
import com.bxm.localnews.admin.vo.VideoFetchKeyword;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.List;


@Service
public class AdminVideoFetchKeywordServiceImpl implements AdminVideoFetchKeywordService {

    private  AdminVideoFetchKeywordMapper adminVideoFetchKeywordMapper;

    @Autowired
    public AdminVideoFetchKeywordServiceImpl(AdminVideoFetchKeywordMapper adminVideoFetchKeywordMapper) {
        this.adminVideoFetchKeywordMapper = adminVideoFetchKeywordMapper;
    }

    @Override
    public void insert(String name) {
        VideoFetchKeyword keyword = new VideoFetchKeyword();
        keyword.setCreateTime(Calendar.getInstance().getTime());
        keyword.setName(name);
        adminVideoFetchKeywordMapper.insert(keyword);
    }

    @Override
    public void delete(Long id) {
        adminVideoFetchKeywordMapper.delete(id);
    }

    @Override
    public PageWarper<VideoFetchKeyword> pageList(PageParam param) {
        return new PageWarper<>(adminVideoFetchKeywordMapper.pageList(param));
    }
}
