package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.domain.AreaDivisionMapper;
import com.bxm.localnews.admin.dto.AreaDivisionDTO;
import com.bxm.localnews.admin.dto.AreaDivisionDetailDTO;
import com.bxm.localnews.admin.service.AreaDivisionService;
import com.bxm.localnews.admin.vo.AreaDivision;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 地区规划相关接口实现类
 */
@Service
public class AreaDivisionServiceImpl implements AreaDivisionService {

    @Autowired
    private AreaDivisionMapper areaDivisionMapper;

    @Override
    public List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode) {
        AreaDivision areaDivisionParam = new AreaDivision();
        if (!"0".equals(parentCode)) {
            areaDivisionParam.setParentCode(parentCode);
        }
        List<AreaDivision> areaDivisionList = areaDivisionMapper.selectByModel(areaDivisionParam);
        return areaDivisionList.stream().map(this::convertDivision).collect(Collectors.toList());
    }

    private AreaDivisionDTO convertDivision(AreaDivision areaDivision) {
        AreaDivisionDTO areaDivisionDTO = new AreaDivisionDTO();
        areaDivisionDTO.setCode(areaDivision.getCode());
        areaDivisionDTO.setLevel(areaDivision.getLevel());
        areaDivisionDTO.setName(areaDivision.getName());
        return areaDivisionDTO;
    }

    private AreaDivisionDetailDTO convertDivisionDetail(AreaDivision areaDivision) {
        AreaDivisionDetailDTO areaDivisionDTO = new AreaDivisionDetailDTO();
        areaDivisionDTO.setCode(areaDivision.getCode());
        areaDivisionDTO.setLevel(areaDivision.getLevel());
        areaDivisionDTO.setName(areaDivision.getName());
        areaDivisionDTO.setFullName(areaDivision.getFullName());
        return areaDivisionDTO;
    }

    @Override
    public AreaDivisionDetailDTO getAreaDivisionDTO(String code) {
        AreaDivision areaDivision = areaDivisionMapper.selectByCode(code);
        AreaDivisionDetailDTO areaDivisionDTO = null;
        if (null != areaDivision) {
            areaDivisionDTO = convertDivisionDetail(areaDivision);
        } else {
            areaDivisionDTO = new AreaDivisionDetailDTO();
        }
        return areaDivisionDTO;
    }

}
