package com.bxm.localnews.admin.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.common.NewsConfigProperties;
import com.bxm.localnews.admin.constant.MarketingActivitiesContentTypeEnum;
import com.bxm.localnews.admin.constant.MarketingActivitiesDeliveryTypeEnum;
import com.bxm.localnews.admin.constant.MarketingActivitiesStatusEnum;
import com.bxm.localnews.admin.constant.NewsAreaRelationTypeEnum;
import com.bxm.localnews.admin.domain.AreaCodeMapper;
import com.bxm.localnews.admin.domain.MarketingActivitiesMapper;
import com.bxm.localnews.admin.domain.NewsDeliveryAreaMapper;
import com.bxm.localnews.admin.param.MarketingActivitiesInfoParam;
import com.bxm.localnews.admin.param.MarketingActivitiesPageQueryParam;
import com.bxm.localnews.admin.service.MarketingActivitiesService;
import com.bxm.localnews.admin.vo.AreaCode;
import com.bxm.localnews.admin.vo.MarketingActivities;
import com.bxm.localnews.admin.vo.NewsDeliveryArea;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
public class MarketingActivitiesServiceImpl implements MarketingActivitiesService {

    private NewsConfigProperties newsConfigProperties;

    private MarketingActivitiesMapper marketingActivitiesMapper;

    private NewsDeliveryAreaMapper newsDeliveryAreaMapper;

    private AreaCodeMapper areaCodeMapper;

    @Autowired(required = false)
    public MarketingActivitiesServiceImpl(NewsConfigProperties newsConfigProperties, MarketingActivitiesMapper marketingActivitiesMapper, NewsDeliveryAreaMapper newsDeliveryAreaMapper,AreaCodeMapper areaCodeMapper) {
        this.newsConfigProperties = newsConfigProperties;
        this.marketingActivitiesMapper = marketingActivitiesMapper;
        this.newsDeliveryAreaMapper = newsDeliveryAreaMapper;
        this.areaCodeMapper = areaCodeMapper;
    }

    @Transactional
    @Override
    public Json addMarketingActivities(String title, String author, String source, Date showTime, Date publishTime, String[] showLevels, Integer deliveryType, String linkUrl, String[] areaCodes, String[] coverUrls) {
        MarketingActivities marketingActivities = new MarketingActivities();
        marketingActivities.setTitle(title);
        marketingActivities.setAuthor(author);
        marketingActivities.setSource(source);
        marketingActivities.setShowTime(showTime);
        marketingActivities.setPublishTime(publishTime);
        marketingActivities.setContentType(MarketingActivitiesContentTypeEnum.EXTERNAL_LINKS.getCode());
        marketingActivities.setLinkUrl(linkUrl);
        marketingActivities.setDeliveryType(deliveryType);
        marketingActivities.setStatus(MarketingActivitiesStatusEnum.DEFAULT.getCode());
        marketingActivities.setCreateTime(Calendar.getInstance().getTime());
        //当前版本只在推荐频道进行投放　
        marketingActivities.setDeliveryChannel(newsConfigProperties.getRecommendKindId());
        if(showLevels!=null&&showLevels.length>0){
            List<String> list = Arrays.asList(showLevels);
            Collections.sort(list);
            //值越小 优先级越高 优先级最高的为当前展示等级（既标签）
            marketingActivities.setShowLevel(Integer.parseInt(list.get(0)));
            marketingActivities.setShowLevelDetail(StringUtils.join(showLevels,","));
        }

        if(coverUrls!=null&&coverUrls.length>0){
            marketingActivities.setCoverUrl(StringUtils.join(coverUrls,","));
        }
        //投放为区域型
        if(deliveryType== MarketingActivitiesDeliveryTypeEnum.AREA.getCode()) {
            if (areaCodes != null && areaCodes.length > 0) {
                List<AreaCode> areaCodeList = new ArrayList<>();

                marketingActivitiesMapper.save(marketingActivities);
                for(String code:areaCodes){
                    NewsDeliveryArea area = new NewsDeliveryArea();
                    AreaCode areaCode = areaCodeMapper.findByCode(code);
                    area.setAreaCode(code);
                    area.setAreaName(areaCode.getAreaName());
                    area.setCreateTime(Calendar.getInstance().getTime());
                    area.setBusinessId(marketingActivities.getId());
                    area.setRelationType(NewsAreaRelationTypeEnum.MARKETING_ACTIVITIES.getCode());
                    newsDeliveryAreaMapper.save(area);
                    areaCodeList.add(areaCode);
                }
                MarketingActivities param = new MarketingActivities();
                param.setAreaDetail(JSON.toJSONString(areaCodeList));
                param.setId(marketingActivities.getId());
                marketingActivitiesMapper.update(param);

            }else{
                return ResultUtil.genFailedResult("投放区域入参错误");
            }
        }else{
            marketingActivitiesMapper.save(marketingActivities);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json disableMarketingActivities(Long id) {
        MarketingActivities marketingActivities = marketingActivitiesMapper.findById(id);
        if(marketingActivities==null){
            return ResultUtil.genFailedResult("该营销活动不存在");
        }
        if(marketingActivities.getStatus()!=MarketingActivitiesStatusEnum.NORMAL.getCode()){
            return ResultUtil.genFailedResult("该活动当前状态不允许下线");
        }
        MarketingActivities param = new MarketingActivities();
        param.setId(marketingActivities.getId());
        param.setStatus(MarketingActivitiesStatusEnum.DISABLE.getCode());
        marketingActivitiesMapper.update(param);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json enableMarketingActivities(Long id) {
        MarketingActivities marketingActivities = marketingActivitiesMapper.findById(id);
        if(marketingActivities==null){
            return ResultUtil.genFailedResult("该营销活动不存在");
        }
        if(marketingActivities.getStatus()!=MarketingActivitiesStatusEnum.DISABLE.getCode()){
            return ResultUtil.genFailedResult("该活动当前状态不允许上线");
        }
        MarketingActivities param = new MarketingActivities();
        param.setId(marketingActivities.getId());
        param.setStatus(MarketingActivitiesStatusEnum.NORMAL.getCode());
        marketingActivitiesMapper.update(param);
        return ResultUtil.genSuccessResult();
    }
    @Transactional
    @Override
    public Json updateMarketingActivities(Long id,String title,String author, String source,Date showTime, Date publishTime,
                                          String[] showLevels,String linkUrl,String[] coverUrls,Integer deliveryType,String areaCodes) {
        MarketingActivities marketingActivities = marketingActivitiesMapper.findById(id);
        if(marketingActivities==null){
            return ResultUtil.genFailedResult("该营销活动不存在");
        }
        MarketingActivities param = new MarketingActivities();
        param.setId(marketingActivities.getId());
        param.setTitle(title);
        param.setAuthor(author);
        param.setSource(source);
        param.setShowTime(showTime);
        //发布时间：当文章发布时间未到时可以编辑发布时间，否则不可编辑
        if(publishTime!=null&&Calendar.getInstance().getTime().before(marketingActivities.getPublishTime())){
            param.setPublishTime(publishTime);
        }
        param.setLinkUrl(linkUrl);
        if(showLevels!=null&&showLevels.length>0){
            List<String> list = Arrays.asList(showLevels);
            Collections.sort(list);
            //值越小 优先级越高 优先级最高的为当前展示等级（既标签）
            param.setShowLevelDetail(StringUtils.join(showLevels,","));
            param.setShowLevel(Integer.parseInt(list.get(0)));

        }
        if(coverUrls!=null&&coverUrls.length>0){
            param.setCoverUrl(StringUtils.join(coverUrls,","));
        }
        //投放为区域型
        if(marketingActivities.getStatus()==MarketingActivitiesStatusEnum.DEFAULT.getCode()
                &&deliveryType== MarketingActivitiesDeliveryTypeEnum.AREA.getCode()) {
            String[] areaCodeArray = areaCodes.split(",");
            if (areaCodeArray != null && areaCodeArray.length > 0) {
                List<AreaCode> areaCodeList = new ArrayList<>();
                newsDeliveryAreaMapper.deleteByBusinessId(id,NewsAreaRelationTypeEnum.MARKETING_ACTIVITIES.getCode());
                for (String code : areaCodeArray) {
                    NewsDeliveryArea area = new NewsDeliveryArea();
                    AreaCode areaCode = areaCodeMapper.findByCode(code);
                    area.setAreaName(areaCode.getAreaName());
                    area.setAreaCode(code);
                    area.setCreateTime(Calendar.getInstance().getTime());
                    area.setBusinessId(marketingActivities.getId());
                    area.setRelationType(NewsAreaRelationTypeEnum.MARKETING_ACTIVITIES.getCode());
                    newsDeliveryAreaMapper.save(area);
                    areaCodeList.add(areaCode);
                }
                marketingActivities.setDeliveryType(deliveryType);
                marketingActivities.setAreaDetail(JSON.toJSONString(areaCodeList));
            } else {
                return ResultUtil.genFailedResult("投放区域入参错误");
            }
        }
        marketingActivitiesMapper.update(marketingActivities);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public PageWarper<MarketingActivities> listForManage(MarketingActivitiesPageQueryParam param) {
        return new PageWarper<>(marketingActivitiesMapper.listForManage(param.getTitle(),param.getShowLevel(),param.getStatus()));
    }

    @Override
    public Json<MarketingActivitiesInfoParam> findById(Long id) {
        MarketingActivities marketingActivities = marketingActivitiesMapper.findById(id);
        MarketingActivitiesInfoParam param = new MarketingActivitiesInfoParam();
        param.setId(marketingActivities.getId());
        param.setAuthor(marketingActivities.getAuthor());
        param.setContent(marketingActivities.getContent());
        param.setContentType(marketingActivities.getContentType());
        param.setCoverUrl(marketingActivities.getCoverUrl());
        param.setCreateAccount(marketingActivities.getCreateAccount());
        param.setCreateTime(marketingActivities.getCreateTime());
        param.setDeliveryChannel(marketingActivities.getDeliveryChannel());
        param.setDeliveryType(marketingActivities.getDeliveryType());
        param.setLinkUrl(marketingActivities.getLinkUrl());
        param.setPublishTime(marketingActivities.getPublishTime());
        param.setShowLevel(marketingActivities.getShowLevel());
        param.setShowLevelDetail(marketingActivities.getShowLevelDetail());
        List<String> levelList = Arrays.asList(marketingActivities.getShowLevelDetail().split(","));
        param.setShowLevelList(levelList);
        param.setShowTime(marketingActivities.getShowTime());
        param.setSource(marketingActivities.getSource());
        param.setStatus(marketingActivities.getStatus());
        param.setTitle(marketingActivities.getTitle());
        if(param.getDeliveryType()==MarketingActivitiesDeliveryTypeEnum.AREA.getCode()){
            List<NewsDeliveryArea> list = newsDeliveryAreaMapper.listByBusinessId(marketingActivities.getId(),NewsAreaRelationTypeEnum.MARKETING_ACTIVITIES.getCode());
            param.setAreaList(list);
        }
        return ResultUtil.genSuccessResult(param);
    }
}
