package com.bxm.localnews.admin.service.impl;

import java.util.Calendar;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AdminNewsBlackMapper;
import com.bxm.localnews.admin.domain.AdminNewsMapper;
import com.bxm.localnews.admin.param.NewsBlackParam;
import com.bxm.localnews.admin.service.NewsService;
import com.bxm.localnews.admin.vo.GlobalNewsBlackEntity;
import com.bxm.localnews.admin.vo.News;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.vo.PageWarper;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsServiceImpl implements NewsService {

    private RedisListAdapter redisListAdapter;

    private AdminNewsMapper adminNewsMapper;

    private AdminNewsBlackMapper adminNewsBlackMapper;

    @Autowired(required = false)
    public NewsServiceImpl(AdminNewsMapper adminNewsMapper, AdminNewsBlackMapper adminNewsBlackMapper,RedisListAdapter redisListAdapter) {
        this.adminNewsMapper = adminNewsMapper;
        this.adminNewsBlackMapper = adminNewsBlackMapper;
        this.redisListAdapter = redisListAdapter;
    }

    @Override
    public PageWarper<News> selectByTitleAndStatus(NewsBlackParam param) {
        return new PageWarper<>(adminNewsMapper.selectByTitleAndStatus(param),10);
    }

    @Transactional
    @Override
    public void addNewsBlack(Long newsId, String remark) {
        GlobalNewsBlackEntity entity = new GlobalNewsBlackEntity();
        entity.setCreateTime(Calendar.getInstance().getTime());
        entity.setRemark(remark);
        entity.setType(0);//无意义缺省值
        entity.setNewsId(newsId);
        adminNewsBlackMapper.insert(entity);
        adminNewsMapper.updateNewsStatusByIds(new String[]{newsId+""},new Byte("2"));
        redisListAdapter.leftTrim(RedisConfig.NEWS_BLACK.copy(),1,0);
    }

    @Transactional
    @Override
    public void delNewsBlack(Long newsId){
        adminNewsBlackMapper.deleteByNewsId(newsId);
        adminNewsMapper.updateNewsStatusByIds(new String[]{newsId+""},new Byte("1"));
        redisListAdapter.leftTrim(RedisConfig.NEWS_BLACK.copy(),1,0);
    }


}
