package com.bxm.localnews.admin.service.strategy;

import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 抽奖策略调度，根据活动获取活动详情，根据活动设置的抽奖策略进行抽奖
 */
@Component
public class DrawStrategDispatcher implements InitializingBean, ApplicationContextAware, DrawStrategyService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DrawStrategDispatcher.class);

    private ApplicationContext applicationContext;

    private Map<String, DrawStrategyService> strategyMap;

    @Override
    public void afterPropertiesSet() {
        strategyMap = applicationContext.getBeansOfType(DrawStrategyService.class);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Message execDraw(PrivilegeBean privilege) {
        if (null == privilege) {
            return Message.build(false).setMessage("活动信息不存在");
        }

        String strategy = privilege.getStrategy();
        DrawStrategyService service = strategyMap.get(strategy);
        if (null == service) {
            String loggerMsg = "活动ID" + privilege.getId() + "配置的策略[" + strategy + "]不存在";
            return Message.build(false).setMessage(loggerMsg);
        }

        return strategyMap.get(strategy).execDraw(privilege);
    }

}
