package com.bxm.localnews.admin.task;

import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.service.strategy.DrawStrategDispatcher;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 活动截止时间到期后触发的定时任务
 * 获取活动详情，根据活动策略进行处理
 */
@Component
public class PrivilegeFinishTask extends AbstractCustomJob {

    @Autowired
    private PrivilegeMapper privilegeMapper;

    @Autowired
    private DrawStrategDispatcher drawStrategDispatcher;

    public PrivilegeFinishTask() {
        super("privilegeFinish", "once");
        super.setCount(0);
    }

    @Override
    protected Message service() {
        Map<String, Object> paramMap = this.getParam();

        if (null != paramMap) {
            Long privilegeId = (Long) this.getParam().get("id");
            PrivilegeBean entity = privilegeMapper.selectByPrimaryKey(privilegeId);
            if (null == entity) {
                logger.warn("活动ID[{}]不存在对应的活动信息", privilegeId);
                return Message.build(false).setMessage("活动ID[" + privilegeId + "]不存在对应的活动信息");
            }
            return drawStrategDispatcher.execDraw(entity);
        }

        return Message.build(false).setMessage("活动截止任务调度失败，缺少参数注入");
    }

}
