package com.bxm.localnews.admin.task;

import com.bxm.localnews.admin.constant.PrivilegeStatusEnum;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Created by Arei on 2018/11/20.
 */
@Component
public class PrivilegeSimpleFinishTask extends AbstractCustomJob {
    @Autowired
    private PrivilegeMapper privilegeMapper;

    public PrivilegeSimpleFinishTask() {
        super("privilegeSimpleFinishTask", "once");
        super.setCount(0);
    }

    @Override
    protected Message service() {
        Map<String, Object> paramMap = this.getParam();

        if (null != paramMap) {
            Long privilegeId = (Long) this.getParam().get("id");

            PrivilegeBean entity = privilegeMapper.selectByPrimaryKey(privilegeId);
            if (null != entity && entity.getStatus() == PrivilegeStatusEnum.BEGIN.getCode()) {
                privilegeMapper.changeStatusAndActualNum(privilegeId, PrivilegeStatusEnum.FINISH.getCode(), 0);
                return Message.build(true);
            } else if (null == entity) {
                return Message.build(false).setMessage("活动ID[" + privilegeId + "]不存在对应的活动信息，活动已删除或配置错误");
            } else {
                return Message.build(false).setMessage("活动[" + privilegeId + "]当前状态不正确，预期为[" + PrivilegeStatusEnum.BEGIN.getCode()
                        + "],实际为[" + entity.getStatus() + "]");
            }
        }

        return Message.build(false).setMessage("活动开启失败，缺少参数注入");
    }
}
