package com.bxm.localnews.admin.task;

import java.util.Map;

import com.bxm.localnews.admin.constant.PrivilegeStatusEnum;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 活动开始状态变更定时任务
 * 创建活动时，根据活动开启时间创建定时任务，当到达时间后变更活动为进行中
 */
@Component
public class PrivilegeStartTask extends AbstractCustomJob {

    @Autowired
    private PrivilegeMapper privilegeMapper;

    public PrivilegeStartTask() {
        super("privilegeStart", "once");
        super.setCount(0);
    }

    @Override
    protected Message service() {
        Map<String, Object> paramMap = this.getParam();

        if (null != paramMap) {
            Long privilegeId = (Long) this.getParam().get("id");

            PrivilegeBean entity = privilegeMapper.selectByPrimaryKey(privilegeId);
            if (null != entity && entity.getStatus() == PrivilegeStatusEnum.WAIT.getCode()) {
                privilegeMapper.changeStatusAndActualNum(privilegeId, PrivilegeStatusEnum.BEGIN.getCode(), 0);
                return Message.build(true);
            } else if (null == entity) {
                return Message.build(false).setMessage("活动ID[" + privilegeId + "]不存在对应的活动信息，活动已删除或配置错误");
            } else {
                return Message.build(false).setMessage("活动[" + privilegeId + "]当前状态不正确，预期为[" + PrivilegeStatusEnum.WAIT.getCode()
                        + "],实际为[" + entity.getStatus() + "]");
            }
        }

        return Message.build(false).setMessage("活动开启失败，缺少参数注入");
    }

}
