/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.admin.common.BizConfigProperties;
import com.bxm.localnews.admin.common.OfflinePushCodeProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AreaPushCodeMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.CodeTemplate;
import com.bxm.localnews.admin.param.PushCodeParam;
import com.bxm.localnews.admin.service.activity.OfflinePushCodeService;
import com.bxm.localnews.admin.service.activity.strategy.PushCodeDispatcher;
import com.bxm.localnews.admin.utils.CompressUtil;
import com.bxm.localnews.admin.vo.AreaPushCode;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.base.model.dto.AvailableDomainInfo;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class OfflinePushCodeServiceImpl
extends BaseService
implements OfflinePushCodeService {
    @Autowired
    private OfflinePushCodeProperties offlinePushCodeProperties;
    @Autowired
    private PushCodeDispatcher pushCodeDispatcher;
    @Autowired
    private BizConfigProperties bizConfigProperties;
    @Autowired
    private AreaPushCodeMapper areaPushCodeMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private DomainIntegrationService domainIntegrationService;
    private List<CodeTemplate> codeTemplates = Lists.newArrayList();

    @PostConstruct
    public void init() {
        List templateCodes = this.offlinePushCodeProperties.getTemplateCode();
        List templateNames = this.offlinePushCodeProperties.getTemplateName();
        List templateImgs = this.offlinePushCodeProperties.getTemplateImg();
        for (int i = 0; i < templateCodes.size(); ++i) {
            CodeTemplate codeTemplate = new CodeTemplate();
            codeTemplate.setTemplateCode((String)templateCodes.get(i));
            codeTemplate.setTemplateName((String)templateNames.get(i));
            codeTemplate.setTemplateImg((String)templateImgs.get(i));
            this.codeTemplates.add(codeTemplate);
        }
    }

    @Override
    public byte[] generatePushCode(PushCodeParam pushCodeParam) {
        CodeTemplate codeTemplate = this.getCodeTemplate(pushCodeParam.getTemplateCode());
        ArrayList areaPushCodes = Lists.newArrayListWithCapacity((int)pushCodeParam.getGenerateNum());
        for (int i = 0; i < pushCodeParam.getGenerateNum(); ++i) {
            if (null == codeTemplate) continue;
            AreaPushCode areaPushCode = this.generatePushCode(codeTemplate, pushCodeParam);
            Message message = this.pushCodeDispatcher.execPushCode(areaPushCode, codeTemplate.getTemplateImg());
            areaPushCodes.add(areaPushCode);
        }
        this.saveAreaPushCodes(areaPushCodes);
        try {
            byte[] bytes = CompressUtil.createZip((String)this.bizConfigProperties.getTempDir());
            return bytes;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u6253\u6210zip\u5305\u51fa\u9519");
            this.logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<CodeTemplate> getCodeTemplates() {
        return this.codeTemplates;
    }

    @Override
    public Message bindPushCode(Long userId, Byte association, String remark, Long code) {
        Message message = Message.build();
        AreaPushCode areaPushCode = this.areaPushCodeMapper.selectById(code);
        if (areaPushCode == null || areaPushCode.getUserId() != null) {
            message.setSuccess(Boolean.FALSE.booleanValue());
            return message;
        }
        areaPushCode.setUserId(userId);
        areaPushCode.setAssociation(association);
        areaPushCode.setRemark(remark);
        this.areaPushCodeMapper.update(areaPushCode);
        this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)this.generateShortCode(code.toString())), (Object)this.getDownloadUrl(userId));
        return message;
    }

    @Override
    public String getUserNickname(Long userId) {
        return this.userMapper.getNicknameById(userId.longValue());
    }

    @Override
    public Boolean userIsExist(Long userId) {
        return this.userMapper.countByUserId(userId.longValue()) > 0;
    }

    private CodeTemplate getCodeTemplate(String templateCode) {
        Optional<CodeTemplate> optional = this.codeTemplates.stream().filter(codeTemplate -> codeTemplate.getTemplateCode().equals(templateCode)).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        return optional.get();
    }

    private String getUrl(String code) {
        Optional baseUrlInfoByScene = this.domainIntegrationService.getBaseUrlInfoByScene(DomainScene.SHORT, null, null);
        String shortCode = this.generateShortCode(code);
        String h5ServerHost = this.domainIntegrationService.getInnerH5BaseUrl();
        this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)shortCode), (Object)(h5ServerHost + "/bindAccount.html?code=" + code));
        return baseUrlInfoByScene.isPresent() ? ((AvailableDomainInfo)baseUrlInfoByScene.get()).getBaseUrl() : "/t/" + shortCode;
    }

    private String generateShortCode(String code) {
        return ShortUrlGenerator.getShortUrl((String)code)[0];
    }

    private String getDownloadUrl(Long userId) {
        return this.domainIntegrationService.getInnerH5BaseUrl() + "pre/h5/offlineDownload.html?userId=" + userId;
    }

    private AreaPushCode generatePushCode(CodeTemplate codeTemplate, PushCodeParam pushCodeParam) {
        Long id = this.nextId();
        return new AreaPushCode(id, pushCodeParam.getAreaCode(), pushCodeParam.getAreaName(), codeTemplate.getTemplateCode(), this.getUrl(id.toString()));
    }

    private void saveAreaPushCodes(List<AreaPushCode> areaPushCodes) {
        if (areaPushCodes.size() > 0) {
            new BatchHelper<AreaPushCodeMapper, AreaPushCode>(AreaPushCodeMapper.class, areaPushCodes, "primarySessionTemplate"){

                protected int invoke(AreaPushCode element) {
                    return ((AreaPushCodeMapper)this.mapper).insert(element);
                }
            };
        }
    }
}

