/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.localnews.admin.domain.RedPacketContentMapper;
import com.bxm.localnews.admin.domain.RedPacketItemMapper;
import com.bxm.localnews.admin.domain.RedPacketShareMapper;
import com.bxm.localnews.admin.dto.RedPacketConfigDTO;
import com.bxm.localnews.admin.dto.RedPacketContentDTO;
import com.bxm.localnews.admin.enums.RedPacketShareType;
import com.bxm.localnews.admin.param.RedPacketConfigParam;
import com.bxm.localnews.admin.service.activity.RedPacketConfigService;
import com.bxm.localnews.admin.vo.RedPacketContent;
import com.bxm.localnews.admin.vo.RedPacketItem;
import com.bxm.localnews.admin.vo.RedPacketShare;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedPacketConfigServiceImpl
implements RedPacketConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketConfigServiceImpl.class);
    private RedPacketContentMapper redPacketContentMapper;
    private RedPacketShareMapper redPacketShareMapper;
    private RedPacketItemMapper redPacketItemMapper;
    private SequenceCreater sequenceCreater;

    @Autowired
    public RedPacketConfigServiceImpl(RedPacketContentMapper redPacketContentMapper, SequenceCreater sequenceCreater, RedPacketShareMapper redPacketShareMapper, RedPacketItemMapper redPacketItemMapper) {
        this.redPacketContentMapper = redPacketContentMapper;
        this.sequenceCreater = sequenceCreater;
        this.redPacketShareMapper = redPacketShareMapper;
        this.redPacketItemMapper = redPacketItemMapper;
    }

    @Override
    public boolean editRedPacketContent(Long id, String content) {
        RedPacketContent redPacketContentEntity = new RedPacketContent();
        redPacketContentEntity.setId(id);
        redPacketContentEntity.setContent(content);
        return this.executeSucBySingle(this.redPacketContentMapper.updateByPrimaryKeySelective(redPacketContentEntity));
    }

    @Override
    public RedPacketContentDTO getContentDetail(Long id) {
        RedPacketContent redPacketContent = this.redPacketContentMapper.selectByPrimaryKey(id);
        if (null == redPacketContent) {
            LOG.error("\u4ee5id:{}\u83b7\u53d6\u53e3\u4ee4\u6a21\u677f\u4e3a\u7a7a", (Object)id);
            return null;
        }
        RedPacketContentDTO resultDTO = new RedPacketContentDTO();
        BeanUtils.copyProperties((Object)redPacketContent, (Object)resultDTO);
        return resultDTO;
    }

    @Override
    public PageWarper<RedPacketContentDTO> getContentList(RedPacketContentDTO redPacketContentDTO) {
        return new PageWarper(this.redPacketContentMapper.queryList(redPacketContentDTO));
    }

    @Override
    public boolean addContent(String content) {
        RedPacketContent redPacketContentEntity = new RedPacketContent();
        redPacketContentEntity.setId(this.sequenceCreater.nextLongId());
        redPacketContentEntity.setContent(content);
        redPacketContentEntity.setCreateTime(new Date());
        return this.executeSucBySingle(this.redPacketContentMapper.insertSelective(redPacketContentEntity));
    }

    @Override
    public boolean delContent(Long id) {
        LOG.info("\u5220\u9664id\u4e3a:{}\u7684\u53e3\u4ee4\u6a21\u677f", (Object)id);
        return this.executeSucBySingle(this.redPacketContentMapper.deleteByPrimaryKey(id));
    }

    @Override
    public boolean addRedPacketConfig(RedPacketConfigParam redPacketConfigParam) {
        redPacketConfigParam.getRedPacketItemList().forEach(redPacketItem -> {
            RedPacketItem redPacketItemEntity = new RedPacketItem();
            redPacketItemEntity.setId(this.sequenceCreater.nextLongId());
            redPacketItemEntity.setAmount(redPacketItem.getAmount());
            redPacketItemEntity.setNum(redPacketItem.getNum());
            this.redPacketItemMapper.insertSelective(redPacketItemEntity);
        });
        this.insertShareList(redPacketConfigParam.getRedPacketShareListWithout());
        this.insertShareList(redPacketConfigParam.getRedPacketShareList());
        return true;
    }

    @Override
    public RedPacketConfigDTO getRedPacketConfig() {
        RedPacketConfigDTO resultDTO = new RedPacketConfigDTO();
        List<RedPacketItem> redPacketItemList = this.getRedPacketItem();
        resultDTO.setRedPacketItemList(redPacketItemList);
        List<RedPacketShare> redPacketShareListWithout = this.getRedPacketShareList(RedPacketShareType.UNRECEIVED.getCode());
        resultDTO.setRedPacketShareListWithout(redPacketShareListWithout);
        List<RedPacketShare> redPacketShareList = this.getRedPacketShareList(RedPacketShareType.ALREADY_RECEIVE.getCode());
        resultDTO.setRedPacketShareList(redPacketShareList);
        return resultDTO;
    }

    @Override
    public boolean editRedPacketConfig(RedPacketConfigParam redPacketConfigParam) {
        this.editRedPacketItem(redPacketConfigParam.getRedPacketItemList());
        this.updateShareList(redPacketConfigParam.getRedPacketShareList());
        this.updateShareList(redPacketConfigParam.getRedPacketShareListWithout());
        return true;
    }

    private boolean insertShareList(List<RedPacketShare> shareList) {
        shareList.forEach(redPacketShare -> {
            RedPacketShare redPacketShareEntity = new RedPacketShare();
            redPacketShareEntity.setId(this.sequenceCreater.nextLongId());
            redPacketShareEntity.setContent(redPacketShare.getContent());
            redPacketShareEntity.setImgUrl(redPacketShare.getImgUrl());
            redPacketShareEntity.setType(redPacketShare.getType());
            redPacketShareEntity.setCreateTime(new Date());
            this.redPacketShareMapper.insertSelective(redPacketShareEntity);
        });
        return true;
    }

    private boolean updateShareList(List<RedPacketShare> shareList) {
        shareList.forEach(redPacketShare -> {
            Long id = redPacketShare.getId();
            RedPacketShare queryRedPacketShare = this.redPacketShareMapper.selectByPrimaryKey(id);
            if (queryRedPacketShare.getContent().equals(redPacketShare.getContent())) {
                return;
            }
            this.redPacketShareMapper.deleteByPrimaryKey(id);
            RedPacketShare redPacketShareEntity = new RedPacketShare();
            redPacketShareEntity.setId(this.sequenceCreater.nextLongId());
            redPacketShareEntity.setContent(redPacketShare.getContent());
            redPacketShareEntity.setImgUrl(redPacketShare.getImgUrl());
            redPacketShareEntity.setType(redPacketShare.getType());
            redPacketShareEntity.setCreateTime(new Date());
            this.redPacketShareMapper.insertSelective(redPacketShareEntity);
        });
        return true;
    }

    private List<RedPacketItem> getRedPacketItem() {
        return this.redPacketItemMapper.queryList();
    }

    private List<RedPacketShare> getRedPacketShareList(Integer type) {
        return this.redPacketShareMapper.queryListByType(type);
    }

    private boolean editRedPacketItem(List<RedPacketItem> redPacketItemList) {
        redPacketItemList.forEach(redPacketItem -> {
            RedPacketItem redPacketItemEntity = new RedPacketItem();
            redPacketItemEntity.setId(redPacketItem.getId());
            redPacketItemEntity.setNum(redPacketItem.getNum());
            redPacketItemEntity.setAmount(redPacketItem.getAmount());
            this.redPacketItemMapper.updateByPrimaryKeySelective(redPacketItemEntity);
        });
        return true;
    }

    private boolean executeSucBySingle(int updateResult) {
        return 1 == updateResult;
    }
}

