/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.strategy;

import com.bxm.localnews.admin.common.BizConfigProperties;
import com.bxm.localnews.admin.service.activity.strategy.PushCodeService;
import com.bxm.localnews.admin.vo.AreaPushCode;
import com.bxm.newidea.component.CodeCreaterFactory;
import com.bxm.newidea.component.param.QrCodeParam;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
public abstract class AbstractPushCodeService
extends BaseService
implements PushCodeService {
    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Override
    public Message execPushCode(AreaPushCode areaPushCode, String codeUrl) {
        Message message = Message.build();
        return message.addParam("file", (Object)this.generateQrcode(areaPushCode, codeUrl));
    }

    abstract File generateQrcode(AreaPushCode var1, String var2);

    File gen(String code, String url, int width, int height) throws IOException {
        String rootPath = this.getRootPath();
        File qrCodeFile = new File(rootPath + code + ".jpg");
        QrCodeParam param = new QrCodeParam();
        param.setWidth(width);
        param.setHeight(height);
        param.setImageFile(qrCodeFile);
        param.setMessage(url);
        param.setLogoPath(this.getIconFile().getPath());
        CodeCreaterFactory.createQrCode((QrCodeParam)param);
        return qrCodeFile;
    }

    File genPushCode(File qrcodeFile, String code, String templateUrl, int x, int y) throws IOException {
        String suffix = "png";
        String finalFileName = code + "_final." + suffix;
        File finalFile = new File(this.getRootPath() + finalFileName);
        BufferedImage finalImgBuffer = this.watermark(this.getSourceFile(templateUrl), qrcodeFile, x, y, 1.0f);
        ImageIO.write((RenderedImage)finalImgBuffer, suffix, finalFile);
        qrcodeFile.delete();
        return finalFile;
    }

    File getSourceFile(String url) {
        return this.getAliyunOssFile(url);
    }

    String getRootPath() {
        return this.bizConfigProperties.getTempDir() + File.separator;
    }

    File getIconFile() {
        return this.getAliyunOssFile(this.bizConfigProperties.getAppIconUrl());
    }

    File getAliyunOssFile(String aliyunFilePath) {
        boolean result;
        File appFile;
        String fileName = StringUtils.substringAfterLast((String)aliyunFilePath, (String)"/");
        String separator = "";
        if (!this.bizConfigProperties.getTempDir().endsWith("/") && !this.bizConfigProperties.getTempDir().endsWith("\\")) {
            separator = File.separator;
        }
        if ((appFile = new File(this.bizConfigProperties.getTempDir() + separator + fileName)).exists()) {
            return appFile;
        }
        File tempDirFile = new File(this.bizConfigProperties.getTempDir());
        if (!tempDirFile.exists() && !(result = tempDirFile.mkdirs())) {
            this.logger.error("\u521b\u5efa[{}]\u76ee\u5f55\u5931\u8d25\uff0c\u53ef\u80fd\u6ca1\u6709\u6743\u9650", (Object)this.bizConfigProperties.getTempDir());
        }
        try {
            FileUtils.copyURLToFile((URL)new URL(aliyunFilePath), (File)appFile);
        }
        catch (IOException e) {
            this.logger.error(aliyunFilePath + "\u914d\u7f6e\u7684\u4e0b\u8f7d\u6587\u4ef6\u8def\u5f84\u4e0d\u6b63\u786e", (Throwable)e);
        }
        return appFile;
    }

    BufferedImage watermark(File file, File waterFile, int x, int y, float alpha) throws IOException {
        BufferedImage buffImg = ImageIO.read(file);
        BufferedImage waterImg = ImageIO.read(waterFile);
        Graphics2D g2d = buffImg.createGraphics();
        int waterImgWidth = waterImg.getWidth();
        int waterImgHeight = waterImg.getHeight();
        g2d.setComposite(AlphaComposite.getInstance(10, alpha));
        g2d.drawImage(waterImg, x, y, waterImgWidth, waterImgHeight, null);
        g2d.dispose();
        return buffImg;
    }
}

