/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AdminAppVersionMapper;
import com.bxm.localnews.admin.dto.AppVersionDTO;
import com.bxm.localnews.admin.enums.VersionForceEnum;
import com.bxm.localnews.admin.param.AppVersionParam;
import com.bxm.localnews.admin.service.base.AdminAppVersionService;
import com.bxm.localnews.admin.service.base.AdminChannelService;
import com.bxm.localnews.admin.vo.AppVersion;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminAppVersionServiceImpl
implements AdminAppVersionService {
    private AdminAppVersionMapper adminAppVersionMapper;
    private AdminChannelService adminChannelService;
    private RedisStringAdapter redisStringAdapter;
    private SequenceCreater sequenceCreater;

    @Autowired
    public AdminAppVersionServiceImpl(AdminAppVersionMapper adminAppVersionMapper, AdminChannelService adminChannelService, RedisStringAdapter redisStringAdapter, SequenceCreater sequenceCreater) {
        this.adminAppVersionMapper = adminAppVersionMapper;
        this.adminChannelService = adminChannelService;
        this.redisStringAdapter = redisStringAdapter;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public PageWarper<AppVersionDTO> getAppVersionList(AppVersionParam appVersionParam) {
        PageWarper pageWarper = new PageWarper(this.adminAppVersionMapper.getAppVersionList(appVersionParam));
        pageWarper.getList().forEach(appVersionDTO -> {
            Channel channel = this.adminChannelService.selectById(appVersionDTO.getChannelId());
            appVersionDTO.setMobileType(channel.getMobileType());
            appVersionDTO.setName(channel.getName());
            appVersionDTO.setCode(channel.getCode());
        });
        return pageWarper;
    }

    @Override
    public AppVersionDTO getAppVersionById(Long id) {
        AppVersionDTO appVersionDTO = new AppVersionDTO();
        AppVersion appVersion = this.adminAppVersionMapper.selectByPrimaryKey(id);
        BeanUtils.copyProperties((Object)appVersion, (Object)appVersionDTO);
        Channel channel = this.adminChannelService.selectById(appVersionDTO.getChannelId());
        appVersionDTO.setMobileType(channel.getMobileType());
        appVersionDTO.setName(channel.getName());
        appVersionDTO.setCode(channel.getCode());
        return appVersionDTO;
    }

    @Override
    public int updateAppVersionStatusById(String[] ids, Byte status, Byte force) {
        return this.adminAppVersionMapper.updateAppVersionStatusById(ids, status, force);
    }

    @Override
    public int updateAppVersionStatusById(AppVersion appVersion) {
        AppVersion oldAppVersion = this.adminAppVersionMapper.selectByPrimaryKey(appVersion.getId());
        if (oldAppVersion == null) {
            return 0;
        }
        this.adminAppVersionMapper.updateByPrimaryKeySelective(appVersion);
        this.removeCache();
        return 1;
    }

    @Override
    public int addAppVersionDetail(AppVersion appVersion) {
        int update;
        Long appVersionId = appVersion.getId();
        if (appVersionId == null) {
            appVersionId = this.sequenceCreater.nextLongId();
        }
        if (!VersionForceEnum.FORCE_UPDATE.getState().equals(appVersion.getForce())) {
            appVersion.setForceVersion("");
        }
        if (appVersion.getStatus() == 1) {
            appVersion.setEnable(Byte.valueOf((byte)0));
        }
        if (appVersion.getId() == null) {
            appVersion.setId(appVersionId);
            appVersion.setCreateTime(new Date());
            update = this.adminAppVersionMapper.insertSelective(appVersion);
        } else {
            update = this.adminAppVersionMapper.updateByPrimaryKeySelective(appVersion);
        }
        this.removeCache();
        return update;
    }

    private KeyGenerator getAppVersionKey() {
        return RedisConfig.BASE_APPVERSION_CHANNEL.copy().appendKey((Object)"list");
    }

    private void removeCache() {
        this.redisStringAdapter.remove(this.getAppVersionKey());
    }
}

