/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.common.BizConfigProperties;
import com.bxm.localnews.admin.constant.AppConst;
import com.bxm.localnews.admin.domain.AdminChannelMapper;
import com.bxm.localnews.admin.dto.ChannelDTO;
import com.bxm.localnews.admin.dto.ChannelStatisDTO;
import com.bxm.localnews.admin.param.ChannelParam;
import com.bxm.localnews.admin.service.base.AdminChannelService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
class AdminChannelServiceImpl
implements AdminChannelService {
    private static final Logger logger = LoggerFactory.getLogger(AdminChannelServiceImpl.class);
    @Resource
    private AdminChannelMapper adminChannelMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private DomainIntegrationService domainIntegrationService;

    AdminChannelServiceImpl() {
    }

    @Override
    public PageWarper<ChannelDTO> queryChannelDTOs(ChannelParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        PageWarper pageWarper = new PageWarper(this.adminChannelMapper.queryChannelDTOByPageSize(param));
        List channelDTOS = pageWarper.getList();
        String channelUrl = StringUtils.join((Object[])new String[]{this.domainIntegrationService.getInnerH5BaseUrl(), "/register.html?inviteUserId="});
        channelDTOS.forEach(channelDTO -> channelDTO.setGeneralizeUrl(channelUrl + channelDTO.getCode()));
        return pageWarper;
    }

    @Override
    public Json insertSelective(Channel channel) {
        channel.setCreateTime(new Date());
        channel.setState(AppConst.STATE_USE);
        channel.setType(Byte.valueOf(Byte.parseByte("10")));
        int i = this.adminChannelMapper.insertSelective(channel);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public Json updateBySelective(Channel channel) {
        int i = this.adminChannelMapper.updateByPrimaryKeySelective(channel);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genSuccessResult((Object)"\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public int countByCode(String code) {
        return this.adminChannelMapper.countByCode(code);
    }

    @Override
    public Json changeState(Long channelId, String state) {
        Channel channel = this.adminChannelMapper.selectByPrimaryKey(channelId);
        if (channel == null) {
            return ResultUtil.genFailedResult((String)"\u64cd\u4f5c\u5931\u8d25,\u65e0\u8be5\u529f\u80fd");
        }
        channel.setState(Byte.valueOf(state));
        int i = this.adminChannelMapper.updateByPrimaryKeySelective(channel);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult((String)"\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Override
    public PageWarper<ChannelStatisDTO> channelStatis(ChannelParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        PageWarper pageWarper = new PageWarper(this.adminChannelMapper.queryChannelStatisDTOByPageSize(param));
        List ret = pageWarper.getList();
        Map<String, Integer> map1 = this.getCacheNum(param);
        if (CollectionUtils.isNotEmpty((Collection)ret)) {
            Iterator iterator = ret.iterator();
            while (iterator.hasNext()) {
                ChannelStatisDTO model;
                model.setOpenCount(map1.get((model = (ChannelStatisDTO)iterator.next()).getCode()) == null ? "0" : map1.get(model.getCode()) + "");
            }
        }
        return pageWarper;
    }

    @Override
    public Channel selectById(Long id) {
        return this.adminChannelMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<Channel> selectRegistChannelList() {
        return this.adminChannelMapper.selectRegistChannel();
    }

    @Override
    public List<Channel> selectAll() {
        return this.adminChannelMapper.selectAll();
    }

    private Map<String, Integer> getCacheNum(ChannelParam channelParam) {
        String begin = channelParam.getBeginTime();
        String end = channelParam.getEndTime();
        if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)begin) || com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)end)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Date beginDate = DateUtils.parseDateNonStrict((String)begin);
        int days = this.getIntervalDays(beginDate, DateUtils.parseDateNonStrict((String)end));
        if (++days <= 0) {
            throw new RuntimeException("\u9009\u62e9\u65f6\u95f4\u8303\u56f4\u6709\u8bef,\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        HashMap map1 = Maps.newHashMap();
        for (int i = 0; i < days; ++i) {
            String newBeginDate = DateUtils.formatDate((Date)DateUtils.addField((Date)beginDate, (int)5, (int)i));
            String nkey = "channel_web_stat:" + newBeginDate;
            Set keySet = this.redisHashMapAdapter.keys((KeyGenerator)RedisKeyGenerator.build((String)nkey));
            for (String subKey : keySet) {
                if (map1.containsKey(subKey)) {
                    Integer num = (Integer)map1.get(subKey) + NumberUtils.parseToInt((String)((String)this.redisHashMapAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)nkey), subKey, String.class)));
                    map1.put(subKey, num);
                    continue;
                }
                map1.put(subKey, NumberUtils.parseToInt((String)((String)this.redisHashMapAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)nkey), subKey, String.class))));
            }
        }
        return map1;
    }

    public int getIntervalDays(Date fDate, Date oDate) {
        if (null == fDate || null == oDate) {
            return -1;
        }
        long intervalMilli = oDate.getTime() - fDate.getTime();
        return (int)(intervalMilli / 86400000L);
    }
}

