/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AreaDivisionMapper;
import com.bxm.localnews.admin.domain.AreaInfoMapper;
import com.bxm.localnews.admin.domain.ImChatroomMapper;
import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.domain.LocationRelationMapper;
import com.bxm.localnews.admin.dto.AreaInfoDTO;
import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.dto.LocationInfoDTO;
import com.bxm.localnews.admin.enums.LocationTypeEnum;
import com.bxm.localnews.admin.integration.IMIntegrationService;
import com.bxm.localnews.admin.param.AreaInfoParam;
import com.bxm.localnews.admin.param.AreaInfoQueryParam;
import com.bxm.localnews.admin.service.base.AreaInfoService;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.vo.AreaDivision;
import com.bxm.localnews.admin.vo.AreaInfo;
import com.bxm.localnews.admin.vo.ImChatroom;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.LocationRelationBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreaInfoServiceImpl
extends BaseService
implements AreaInfoService {
    private final AreaInfoMapper areaInfoMapper;
    private final AreaDivisionMapper areaDivisionMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final LocationRelationMapper locationRelationMapper;
    private final LocationMapper locationMapper;
    private final IMIntegrationService imIntegrationService;
    private final ImChatroomMapper imChatroomMapper;
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public AreaInfoServiceImpl(AreaInfoMapper areaInfoMapper, AreaDivisionMapper areaDivisionMapper, RedisStringAdapter redisStringAdapter, LocationRelationMapper locationRelationMapper, LocationMapper locationMapper, RedisHashMapAdapter redisHashMapAdapter, IMIntegrationService imIntegrationService, ImChatroomMapper imChatroomMapper) {
        this.areaInfoMapper = areaInfoMapper;
        this.areaDivisionMapper = areaDivisionMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.locationRelationMapper = locationRelationMapper;
        this.locationMapper = locationMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.imIntegrationService = imIntegrationService;
        this.imChatroomMapper = imChatroomMapper;
    }

    @Override
    public PageWarper<AreaInfo> queryPages(AreaInfoQueryParam areaInfoParam) {
        PageWarper pageWarper = new PageWarper(this.areaInfoMapper.queryByPageSize(areaInfoParam));
        pageWarper.getList().forEach(areaInfo -> {
            Location location = this.locationMapper.selectByCode(areaInfo.getCode());
            if (location != null) {
                areaInfo.setEnableVip(location.getEnableVip());
                areaInfo.setEnablePaidPromote(location.getEnablePaidPromote());
                areaInfo.setEnableCommunityContent(location.getEnableCommunityContent());
                areaInfo.setEnableIndexPublish(location.getEnableIndexPublish());
                areaInfo.setEnableCustomerService(location.getEnableCustomerService());
                areaInfo.setEnableChatRoom(location.getEnableChatRoom());
                areaInfo.setLastCode(location.getLastCode());
                areaInfo.setEnableGroupCustomerServicePhone(location.getEnableGroupCustomerServicePhone());
            }
        });
        return pageWarper;
    }

    @Override
    public Message saveAreaInfo(AreaInfoParam areaInfoParam) {
        AreaInfo areaInfo = this.areaInfoMapper.selectByCode(areaInfoParam.getCode());
        if (null != areaInfo) {
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        AreaInfo areaInfoEntity = this.convertAreaInfo(areaInfoParam);
        int count = this.areaInfoMapper.insertSelective(areaInfoEntity);
        this.saveLocation(areaInfoParam);
        if (count == 1) {
            List areaInfoList = this.areaInfoMapper.queryByPageSize(null);
            this.redisStringAdapter.set(RedisConfig.AREA_INFO, (Object)areaInfoList);
        }
        return Message.build((int)count);
    }

    private AreaInfo convertAreaInfo(AreaInfoParam areaInfoParam) {
        AreaInfo areaInfo = new AreaInfo();
        areaInfo.setName(areaInfoParam.getName());
        areaInfo.setCode(areaInfoParam.getCode());
        areaInfo.setCoverRate(areaInfoParam.getCoverRate());
        areaInfo.setDescription(areaInfoParam.getDescription());
        areaInfo.setPopulation(areaInfoParam.getPopulation());
        areaInfo.setTransmissionRate(areaInfoParam.getTransmissionRate());
        if (areaInfoParam.getId() != null) {
            areaInfo.setId(areaInfoParam.getId());
        } else {
            areaInfo.setId(this.nextSequence());
        }
        return areaInfo;
    }

    private void saveLocation(AreaInfoParam areaInfo) {
        Location location = new Location();
        location.setCode(areaInfo.getCode());
        location.setEnableVip(areaInfo.getEnableVip());
        location.setInvitedCount(Integer.valueOf(areaInfo.getInvitedCount()));
        location.setReductionAmount(areaInfo.getValue());
        location.setEnablePaidPromote(areaInfo.getEnablePaidPromote());
        if (StringUtils.isNotEmpty((CharSequence)areaInfo.getNewRedPacket())) {
            location.setNewRedPacket(new BigDecimal(areaInfo.getNewRedPacket()));
        }
        if (StringUtils.isNotEmpty((CharSequence)areaInfo.getPromoteBounty())) {
            location.setPromoteBounty(new BigDecimal(areaInfo.getPromoteBounty()));
        }
        location.setEnableChatRoom(Byte.valueOf(Objects.nonNull(areaInfo.getEnableChatRoom()) ? areaInfo.getEnableChatRoom() : (byte)0));
        this.locationMapper.updateByCodeSelective(location);
        if (areaInfo.getType() == null) {
            areaInfo.setType(Integer.valueOf(0));
        }
        if (LocationTypeEnum.VIP.getCode() == areaInfo.getType().intValue()) {
            areaInfo.getShareWechatSeg().forEach(seg -> {
                if (seg.getId() == null) {
                    seg.setId(Long.valueOf(this.nextId()));
                }
                seg.setType(Byte.valueOf((byte)1));
                seg.setCreateTime(new Date());
                seg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getShareMomentSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)2));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getShareWechatImgSeg().forEach(seg -> {
                if (seg.getId() == null) {
                    seg.setId(Long.valueOf(this.nextId()));
                }
                seg.setType(Byte.valueOf((byte)3));
                seg.setCreateTime(new Date());
                seg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getShareMomentImgSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)4));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
        }
        if (LocationTypeEnum.PROMOTION.getCode() == areaInfo.getType().intValue()) {
            areaInfo.getShareMiniAppWechatSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)5));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getShareMiniAppWechatImgSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)6));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getShareMiniAppMomentSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)7));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getShareMiniAppMomentImgSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)8));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getRecallMiniAppWechatImgSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)9));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
            areaInfo.getRecallMiniAppMomentImgSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)10));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
        }
        if (LocationTypeEnum.CHATROOM.getCode() == areaInfo.getType().intValue()) {
            areaInfo.getChatRoomImgSeg().forEach(momentSeg -> {
                if (momentSeg.getId() == null) {
                    momentSeg.setId(Long.valueOf(this.nextId()));
                }
                momentSeg.setType(Byte.valueOf((byte)11));
                momentSeg.setCreateTime(new Date());
                momentSeg.setLocationCode(areaInfo.getCode());
            });
        }
        List relationBeans = this.locationRelationMapper.selectByCodeAndType(areaInfo.getCode(), areaInfo.getType());
        ArrayList paramRelationBeans = Lists.newArrayList();
        if (LocationTypeEnum.VIP.getCode() == areaInfo.getType().intValue()) {
            paramRelationBeans.addAll(areaInfo.getShareWechatSeg());
            paramRelationBeans.addAll(areaInfo.getShareWechatImgSeg());
            paramRelationBeans.addAll(areaInfo.getShareMomentSeg());
            paramRelationBeans.addAll(areaInfo.getShareMomentImgSeg());
            this.logger.info("\u5f85\u4fdd\u5b58\u7684vip\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)paramRelationBeans));
        }
        if (LocationTypeEnum.PROMOTION.getCode() == areaInfo.getType().intValue()) {
            paramRelationBeans.addAll(areaInfo.getShareMiniAppWechatSeg());
            paramRelationBeans.addAll(areaInfo.getShareMiniAppWechatImgSeg());
            paramRelationBeans.addAll(areaInfo.getShareMiniAppMomentSeg());
            paramRelationBeans.addAll(areaInfo.getShareMiniAppMomentImgSeg());
            paramRelationBeans.addAll(areaInfo.getRecallMiniAppWechatImgSeg());
            paramRelationBeans.addAll(areaInfo.getRecallMiniAppMomentImgSeg());
            this.logger.info("\u5f85\u4fdd\u5b58\u7684\u63a8\u5e7f\u8d5a\u94b1\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)paramRelationBeans));
        }
        if (LocationTypeEnum.CHATROOM.getCode() == areaInfo.getType().intValue()) {
            paramRelationBeans.addAll(areaInfo.getChatRoomImgSeg());
            this.logger.info("\u5f85\u4fdd\u5b58\u7684\u804a\u5929\u5ba4\u914d\u7f6e\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)paramRelationBeans));
        }
        for (LocationRelationBean entity : paramRelationBeans) {
            if (StringUtils.isBlank((CharSequence)entity.getContent())) {
                this.locationRelationMapper.deleteById(entity.getId());
                continue;
            }
            if (relationBeans.stream().anyMatch(relation -> StringUtils.equals((CharSequence)relation.getContent(), (CharSequence)entity.getContent()) && StringUtils.equals((CharSequence)relation.getImageUrl(), (CharSequence)entity.getImageUrl()) && StringUtils.equals((CharSequence)relation.getContentDescription(), (CharSequence)entity.getContentDescription()) && StringUtils.equals((CharSequence)relation.getWebShareDes(), (CharSequence)entity.getWebShareDes()))) continue;
            entity.setId(Long.valueOf(this.nextId()));
            this.locationRelationMapper.insert(entity);
        }
        for (LocationRelationBean entity : relationBeans) {
            if (paramRelationBeans.stream().anyMatch(relation -> Objects.equals(entity.getId(), relation.getId()))) continue;
            this.locationRelationMapper.deleteById(entity.getId());
        }
        if (LocationTypeEnum.CHATROOM.getCode() == areaInfo.getType().intValue()) {
            ImChatroom imChatroom = this.imChatroomMapper.selectByCode(areaInfo.getCode());
            imChatroom.setEnableChatRoom(areaInfo.getEnableChatRoom());
            imChatroom.setEnableTimingRedPacket(areaInfo.getEnableTimingRedPacket());
            imChatroom.setModifyTime(new Date());
            imChatroom.setStartIntervalNumber(areaInfo.getStartIntervalNumber());
            imChatroom.setEndIntervalNumber(areaInfo.getEndIntervalNumber());
            imChatroom.setChatRoomName(areaInfo.getChatRoomName());
            this.imChatroomMapper.updateByPrimaryKeySelective(imChatroom);
        }
    }

    @Override
    public int updateAreaInfo(AreaInfoParam areaInfoParam) {
        AreaInfo areaInfo = this.convertAreaInfo(areaInfoParam);
        int count = this.areaInfoMapper.updateByPrimaryKeySelective(areaInfo);
        this.saveLocation(areaInfoParam);
        if (count == 1) {
            List areaInfoList = this.areaInfoMapper.queryByPageSize(null);
            this.redisStringAdapter.set(RedisConfig.AREA_INFO, (Object)areaInfoList);
        }
        return count;
    }

    @Override
    public int delAreaInfo(String code) {
        int count = this.areaInfoMapper.deleteByCode(code);
        this.locationRelationMapper.delete(code);
        if (count == 1) {
            List areaInfoList = this.areaInfoMapper.queryByPageSize(null);
            this.redisStringAdapter.set(RedisConfig.AREA_INFO, (Object)areaInfoList);
        }
        return count;
    }

    @Override
    public AreaInfoDTO getAreaInfo(String code) {
        AreaDivision areaDivisionUp;
        AreaInfo areaInfo = this.areaInfoMapper.selectByCode(code);
        AreaDivision areaDivision = this.areaDivisionMapper.selectByCode(areaInfo.getCode());
        String parentCode = areaDivision.getParentCode();
        if (null != parentCode && null != (areaDivisionUp = this.areaDivisionMapper.selectByCode(parentCode)).getParentCode()) {
            parentCode = areaDivisionUp.getParentCode();
        }
        String parentName = this.areaDivisionMapper.selectByCode(parentCode).getName();
        AreaInfoDTO areaInfoDTO = new AreaInfoDTO();
        areaInfoDTO.setId(areaInfo.getId());
        areaInfoDTO.setProvinceCode(parentCode);
        areaInfoDTO.setName(areaInfo.getName());
        areaInfoDTO.setProvinceName(parentName);
        areaInfoDTO.setCode(areaInfo.getCode());
        areaInfoDTO.setCoverRate(areaInfo.getCoverRate());
        areaInfoDTO.setTransmissionRate(areaInfo.getTransmissionRate());
        areaInfoDTO.setPopulation(areaInfo.getPopulation());
        areaInfoDTO.setDescription(areaInfo.getDescription());
        Location location = this.locationMapper.selectByCode(code);
        areaInfoDTO.setEnableChatRoom(location.getEnableChatRoom());
        ImChatroom imChatroom = this.imChatroomMapper.selectByCode(code);
        if (Objects.isNull(imChatroom)) {
            areaInfoDTO.setEnableTimingRedPacket(Byte.valueOf((byte)0));
            areaInfoDTO.setChatRoomId(null);
        } else {
            areaInfoDTO.setEnableTimingRedPacket(imChatroom.getEnableTimingRedPacket());
            areaInfoDTO.setChatRoomId(imChatroom.getChatRoomId());
            areaInfoDTO.setStartIntervalNumber(imChatroom.getStartIntervalNumber());
            areaInfoDTO.setEndIntervalNumber(imChatroom.getEndIntervalNumber());
            areaInfoDTO.setChatRoomName(imChatroom.getChatRoomName());
        }
        areaInfoDTO.setEnableVip(location.getEnableVip());
        areaInfoDTO.setInvitedCount(location.getInvitedCount().intValue());
        areaInfoDTO.setValue(location.getReductionAmount());
        areaInfoDTO.setEnablePaidPromote(location.getEnablePaidPromote());
        areaInfoDTO.setNewRedPacket(location.getNewRedPacket());
        areaInfoDTO.setPromoteBounty(location.getPromoteBounty());
        List relationBeans = this.locationRelationMapper.selectByCode(code);
        areaInfoDTO.setShareWechatSeg(relationBeans.stream().filter(seg -> seg.getType() == 1).collect(Collectors.toList()));
        areaInfoDTO.setShareMomentSeg(relationBeans.stream().filter(seg -> seg.getType() == 2).collect(Collectors.toList()));
        areaInfoDTO.setShareWechatImgSeg(relationBeans.stream().filter(seg -> seg.getType() == 3).collect(Collectors.toList()));
        areaInfoDTO.setShareMomentImgSeg(relationBeans.stream().filter(seg -> seg.getType() == 4).collect(Collectors.toList()));
        areaInfoDTO.setShareMiniAppWechatSeg(relationBeans.stream().filter(seg -> seg.getType() == 5).collect(Collectors.toList()));
        areaInfoDTO.setShareMiniAppWechatImgSeg(relationBeans.stream().filter(seg -> seg.getType() == 6).collect(Collectors.toList()));
        areaInfoDTO.setShareMiniAppMomentSeg(relationBeans.stream().filter(seg -> seg.getType() == 7).collect(Collectors.toList()));
        areaInfoDTO.setShareMiniAppMomentImgSeg(relationBeans.stream().filter(seg -> seg.getType() == 8).collect(Collectors.toList()));
        areaInfoDTO.setRecallMiniAppWechatImgSeg(relationBeans.stream().filter(seg -> seg.getType() == 9).collect(Collectors.toList()));
        areaInfoDTO.setRecallMiniAppMomentImgSeg(relationBeans.stream().filter(seg -> seg.getType() == 10).collect(Collectors.toList()));
        areaInfoDTO.setChatRoomImgSeg(relationBeans.stream().filter(seg -> seg.getType() == 11).collect(Collectors.toList()));
        areaInfoDTO.setVipShareContentSeg(relationBeans.stream().filter(seg -> seg.getType() == 12).collect(Collectors.toList()));
        return areaInfoDTO;
    }

    @Override
    public int updateCommunityContent(AreaInfoParam areaInfo) {
        Location location = new Location();
        location.setCode(areaInfo.getCode());
        location.setEnableCommunityContent(areaInfo.getEnableCommunityContent());
        return this.locationMapper.updateByCodeSelective(location);
    }

    @Override
    public int updateCustomerService(AreaInfoParam areaInfoParam) {
        this.redisHashMapAdapter.remove(RedisConfig.CUSTOMER_SERVICE_INFO, new String[]{areaInfoParam.getCode()});
        Location location = new Location();
        location.setCode(areaInfoParam.getCode());
        location.setEnableCustomerService(areaInfoParam.getEnableCustomerService());
        location.setCustomerServiceNumber(areaInfoParam.getCustomerServiceNumber());
        location.setCustomerServiceQrCode(areaInfoParam.getCustomerServiceQrCode());
        return this.locationMapper.updateByCodeSelective(location);
    }

    @Override
    public int updateIndexPublish(AreaInfoParam areaInfo) {
        Location location = new Location();
        location.setCode(areaInfo.getCode());
        location.setEnableIndexPublish(areaInfo.getEnableIndexPublish());
        return this.locationMapper.updateByCodeSelective(location);
    }

    @Override
    public LocationInfoDTO getLocationInfo(String code) {
        Location location = this.locationMapper.selectByCode(code);
        LocationInfoDTO locationInfoDTO = new LocationInfoDTO();
        if (null == location) {
            this.logger.error("\u67e5\u8be2location\u4fe1\u606f\u4e3a\u7a7a,\u67e5\u8be2code\u4e3a:{}", (Object)code);
            return null;
        }
        locationInfoDTO.setEnableCommunityContent(location.getEnableCommunityContent());
        locationInfoDTO.setEnableCustomerService(location.getEnableCustomerService());
        locationInfoDTO.setEnableIndexPublish(location.getEnableIndexPublish());
        locationInfoDTO.setCustomerServiceNumber(location.getCustomerServiceNumber());
        locationInfoDTO.setCustomerServiceQrCode(location.getCustomerServiceQrCode());
        locationInfoDTO.setCode(location.getCode());
        locationInfoDTO.setName(location.getName());
        return locationInfoDTO;
    }

    @Override
    public List<LocationDTO> getHotCity() {
        KeyGenerator hotCityKey = RedisConfig.HOT_LOCATION;
        TypeReference<List<LocationDTO>> hotCityTypeReference = new TypeReference<List<LocationDTO>>(){};
        List<LocationDTO> hotLocationList = (List<LocationDTO>)this.redisStringAdapter.get(hotCityKey, (TypeReference)hotCityTypeReference);
        if (hotLocationList == null) {
            LocationService locationService = (LocationService)SpringContextHolder.getBean(LocationService.class);
            hotLocationList = locationService.listHotLocation();
            this.redisStringAdapter.set(hotCityKey, hotLocationList);
        }
        return hotLocationList;
    }

    @Override
    public List<LocationRelationBean> getDetailByCodeType(String code, Integer type) {
        Location location = this.locationMapper.selectByCode(code);
        if (null == location) {
            return null;
        }
        ArrayList<LocationRelationBean> relationBeans = this.locationRelationMapper.selectByCodeAndType(code, type);
        if (null != relationBeans && relationBeans.size() > 0) {
            for (LocationRelationBean bean : relationBeans) {
                bean.setName(location.getFullName());
            }
        } else {
            LocationRelationBean bean = new LocationRelationBean();
            bean.setName(location.getFullName());
            bean.setLocationCode(code);
            relationBeans = new ArrayList<LocationRelationBean>();
            relationBeans.add(bean);
        }
        return relationBeans;
    }
}

