/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AreaDivisionMapper;
import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.domain.LocationRelationMapper;
import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.param.AreaCustomerPhoneParam;
import com.bxm.localnews.admin.param.LocationPageParam;
import com.bxm.localnews.admin.param.LocationParam;
import com.bxm.localnews.admin.param.LocationRelationParam;
import com.bxm.localnews.admin.param.ModifyLocationParam;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.vo.AreaCode;
import com.bxm.localnews.admin.vo.AreaDivision;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.LocationPhoneVO;
import com.bxm.localnews.admin.vo.LocationRelationBean;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.PinyinUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationServiceImpl
extends BaseService
implements LocationService {
    private final LocationMapper locationMapper;
    private final AreaDivisionMapper areaDivisionMapper;
    private final RedisStringAdapter redisStringAdapter;
    private LocationRelationMapper locationRelationMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private LoadingCache<String, Map<String, Location>> cache;

    @Autowired
    public LocationServiceImpl(LocationMapper locationMapper, AreaDivisionMapper areaDivisionMapper, RedisStringAdapter redisStringAdapter, LocationRelationMapper locationRelationMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.locationMapper = locationMapper;
        this.areaDivisionMapper = areaDivisionMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.locationRelationMapper = locationRelationMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public List<LocationDTO> listLocationByPage(LocationPageParam param) {
        Page page = PageHelper.startPage((Object)param).doSelectPage(() -> this.locationMapper.selectByPage(param));
        return page.stream().map(this::convertLocation).collect(Collectors.toList());
    }

    @Override
    public List<LocationDTO> listLocation(LocationParam locationParam) {
        Location location = new Location();
        BeanUtils.copyProperties((Object)locationParam, (Object)location);
        if (Objects.equals("\u5168\u56fd", locationParam.getName())) {
            LocationDTO locationDTO = new LocationDTO();
            locationDTO.setCode("0");
            locationDTO.setName("\u5168\u56fd");
            return Collections.singletonList(locationDTO);
        }
        List locationList = this.locationMapper.selectByModel(location);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        return locationDTOList;
    }

    @Override
    public ResponseJson modifyLocation(ModifyLocationParam param) {
        if (Objects.isNull(param.getId())) {
            return ResponseJson.badReqeuset((String)"\u8981\u7f16\u8f91\u7684id\u4e3a\u7a7a").build();
        }
        Location location = new Location();
        location.setId(param.getId());
        location.setLastCode(param.getLastCode());
        this.locationMapper.updateByPrimaryKeySelective(location);
        return ResponseJson.ok().build();
    }

    @Override
    public void saveHotLocation(String code) {
        Location location = this.locationMapper.selectByCode(code);
        if (location.getHot().equals((byte)0)) {
            location.setHot(Byte.valueOf((byte)1));
            location.setShow(Byte.valueOf((byte)1));
            int count = this.locationMapper.updateByCodeSelective(location);
            if (count == 1) {
                List<LocationDTO> locationDTOList = this.listHotLocation();
                this.redisStringAdapter.set(RedisConfig.HOT_LOCATION, locationDTOList);
            }
        }
    }

    @Override
    public List<LocationDTO> listHotLocation() {
        Location locationParam = new Location();
        locationParam.setHot(Byte.valueOf((byte)1));
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        return locationDTOList;
    }

    private List<LocationDTO> listOpenedLocation() {
        Location locationParam = new Location();
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        locationDTOList.forEach(x -> x.setPinyin(PinyinUtils.getPinYinHeadChar((String)x.getName()).substring(0, 1).toUpperCase()));
        return locationDTOList;
    }

    @Override
    public void saveOpenedLocation(String code) {
        Location location = this.locationMapper.selectByCode(code);
        if (location.getShow().equals((byte)0)) {
            location.setShow(Byte.valueOf((byte)1));
            int count = this.locationMapper.updateByCodeSelective(location);
            if (count == 1) {
                List<LocationDTO> locationDTOList = this.listOpenedLocation();
                this.redisStringAdapter.set(RedisConfig.OPENED_LOCATION, locationDTOList);
            }
        }
    }

    @Override
    public List<LocationDTO> listOpenedLocationByArea(String code, Byte show) {
        ArrayList<Location> locationList = new ArrayList<Location>();
        Location location = this.locationMapper.selectByCode(code);
        List locationListByParent = this.locationMapper.selectByParentCode(code, show);
        if (null != location) {
            locationList.add(location);
        }
        if (CollectionUtils.isNotEmpty((Collection)locationListByParent)) {
            locationList.addAll(locationListByParent);
        }
        return locationList.stream().map(this::convertLocation).collect(Collectors.toList());
    }

    @Override
    public List<LocationDTO> listOpenedLocationByAreaWithTwoLevels(String code, Byte show) {
        ArrayList<LocationDTO> locationDTOList = new ArrayList();
        AreaDivision areaDivisionParam = new AreaDivision();
        areaDivisionParam.setParentCode(code);
        List areaDivisionList = this.areaDivisionMapper.selectByModel(areaDivisionParam);
        for (AreaDivision areaDivision : areaDivisionList) {
            List<LocationDTO> temLocationDTOList = this.listOpenedLocationByArea(areaDivision.getCode(), show);
            locationDTOList.addAll(temLocationDTOList);
        }
        locationDTOList = locationDTOList.stream().sorted(Comparator.comparing(x -> x.getPinyin().substring(0, 1))).collect(Collectors.toList());
        return locationDTOList;
    }

    @Override
    public Map<String, Location> listLocation() {
        if (this.cache == null) {
            this.cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, Location>>(){

                public Map<String, Location> load(String key) throws Exception {
                    Location location = new Location();
                    List locationList = LocationServiceImpl.this.locationMapper.selectByModel(location);
                    return locationList.stream().collect(Collectors.toMap(Location::getCode, Function.identity(), (key1, key2) -> key2));
                }
            });
        }
        return (Map)this.cache.getUnchecked((Object)"all");
    }

    @Override
    public String getAreaDetail(String[] areaDetailArray) {
        Map<String, Location> locationMap = this.listLocation();
        ArrayList areaCodeList = new ArrayList();
        Arrays.stream(areaDetailArray).forEach(e -> {
            if (locationMap.get(e) != null) {
                AreaCode areaCode = new AreaCode();
                areaCode.setAreaCode(e);
                areaCode.setAreaName(((Location)locationMap.get(e)).getName());
                areaCodeList.add(areaCode);
            }
        });
        return JSONObject.toJSONString(areaCodeList);
    }

    @Override
    public List<Location> getLocationsByAreaCodes(List<String> areaCodes) {
        if (CollectionUtils.isNotEmpty(areaCodes)) {
            ArrayList<Location> areas = new ArrayList<Location>();
            for (String areaCode : areaCodes) {
                Location location = this.locationMapper.selectByCode(areaCode);
                if (null == location) continue;
                areas.add(location);
            }
            return areas;
        }
        return null;
    }

    @Override
    public Boolean saveLocationRelation(LocationRelationParam param) {
        LocationRelationBean bean = new LocationRelationBean();
        BeanUtils.copyProperties((Object)param, (Object)bean);
        bean.setId(Long.valueOf(this.nextId()));
        bean.setCreateTime(new Date());
        return this.locationRelationMapper.insertAll(bean) > 0;
    }

    @Override
    public Boolean updateLocationRelation(LocationRelationParam param) {
        if (null == param.getId()) {
            return false;
        }
        LocationRelationBean bean = new LocationRelationBean();
        BeanUtils.copyProperties((Object)param, (Object)bean);
        return this.locationRelationMapper.updateBySelective(bean) > 0;
    }

    @Override
    public Boolean updateLocationPhone(AreaCustomerPhoneParam param) {
        if (StringUtils.isBlank((CharSequence)param.getCode())) {
            return false;
        }
        Location location = new Location();
        location.setEnableGroupCustomerServicePhone(param.getEnableGroupCustomerServicePhone());
        location.setGroupCustomerServicePhone(param.getGroupCustomerServicePhone());
        location.setCode(param.getCode());
        if (this.redisHashMapAdapter.exists(RedisConfig.GROUP_CUSTOMER_PHONE, param.getCode()).booleanValue()) {
            this.redisHashMapAdapter.remove(RedisConfig.GROUP_CUSTOMER_PHONE, new String[]{param.getCode()});
        }
        return this.locationMapper.updateByCodeSelective(location) > 0;
    }

    @Override
    public LocationPhoneVO getLocationPhoneByCode(String code) {
        LocationPhoneVO phoneVO = new LocationPhoneVO();
        if (StringUtils.isBlank((CharSequence)code)) {
            return phoneVO;
        }
        Location location = this.locationMapper.selectByCode(code);
        phoneVO.setCode(code);
        phoneVO.setName(location.getName());
        phoneVO.setEnableGroupCustomerServicePhone(location.getEnableGroupCustomerServicePhone());
        phoneVO.setGroupCustomerServicePhone(location.getGroupCustomerServicePhone());
        return phoneVO;
    }

    private LocationDTO convertLocation(Location location) {
        LocationDTO locationDTO = new LocationDTO();
        locationDTO.setCode(location.getCode());
        locationDTO.setId(location.getId());
        locationDTO.setHot(location.getHot());
        locationDTO.setShow(location.getShow());
        locationDTO.setLevel(location.getLevel());
        locationDTO.setName(location.getName());
        locationDTO.setPinyin(location.getPinyin());
        locationDTO.setLastCode(location.getLastCode());
        return locationDTO;
    }

    private LocationDTO convertLocationByDivision(AreaDivision areaDivision) {
        LocationDTO locationDTO = new LocationDTO();
        locationDTO.setCode(areaDivision.getCode());
        locationDTO.setLevel(areaDivision.getLevel());
        locationDTO.setName(areaDivision.getName());
        return locationDTO;
    }
}

