/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.im.impl;

import com.bxm.localnews.admin.common.ImChatRoomProperties;
import com.bxm.localnews.admin.domain.ImChatroomExtendMapper;
import com.bxm.localnews.admin.domain.ImTimingRedPacketPlanExtendMapper;
import com.bxm.localnews.admin.entry.ImTimingRedPacketPlan;
import com.bxm.localnews.admin.integration.IMIntegrationService;
import com.bxm.localnews.admin.param.CreateRedPacketTaskFacadeParam;
import com.bxm.localnews.admin.param.CreateTimingRedPacketPlanParam;
import com.bxm.localnews.admin.param.IdParam;
import com.bxm.localnews.admin.param.ListPlansByChatRoomIdParam;
import com.bxm.localnews.admin.param.RemoveRedPacketTaskFacadeParam;
import com.bxm.localnews.admin.param.UpdateTimingRedPacketPlanParam;
import com.bxm.localnews.admin.service.im.ImChatRoomRedPacketService;
import com.bxm.localnews.admin.vo.ImChatroom;
import com.bxm.localnews.admin.vo.im.ImTimingRedPacketPlanVO;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImChatRoomRedPacketServiceImpl
implements ImChatRoomRedPacketService {
    private static final Logger log = LoggerFactory.getLogger(ImChatRoomRedPacketServiceImpl.class);
    @Autowired
    private ImTimingRedPacketPlanExtendMapper imTimingRedPacketPlanExtendMapper;
    @Autowired
    private ImChatroomExtendMapper imChatroomExtendMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private ImChatRoomProperties imChatRoomProperties;
    @Autowired
    private IMIntegrationService imIntegrationService;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private static final BigDecimal MIX = BigDecimal.valueOf(0.01);

    private ImTimingRedPacketPlanVO build(ImTimingRedPacketPlan plan) {
        return ImTimingRedPacketPlanVO.builder().chatRoomId(plan.getRedPacketTargetId()).createTime(plan.getCreateTime()).id(plan.getId()).modifyTime(plan.getModifyTime()).redPacketName(plan.getRedPacketName()).redPacketTotalAmount(plan.getRedPacketTotalAmount()).redPacketTotalNum(plan.getRedPacketTotalNum()).sentTimeStr(((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get()).format(plan.getSentTime())).status(plan.getStatus()).build();
    }

    @Override
    public Json createTimingRedPacketPlan(CreateTimingRedPacketPlanParam param) {
        List imTimingRedPacketPlans = this.imTimingRedPacketPlanExtendMapper.listPlansByChatRoomId(param.getChatRoomId());
        if (this.hasNearest(imTimingRedPacketPlans, param.getSentTime())) {
            return Json.badReqeuset((String)"\u8bf7\u52ff\u6dfb\u52a0\u76f8\u5dee\u65f6\u95f45m\u4e4b\u5185\u7684\u7ea2\u5305");
        }
        if (!this.checkAmt(param.getRedPacketTotalAmount(), param.getRedPacketTotalNum())) {
            return Json.badReqeuset((String)"\u5e73\u5747\u6bcf\u4e2a\u7ea2\u5305\u4e0d\u53ef\u5c11\u4e8e0.01\u5143");
        }
        Date now = new Date();
        ImTimingRedPacketPlan plan = new ImTimingRedPacketPlan();
        plan.setRedPacketTargetId(param.getChatRoomId());
        plan.setRedPacketTotalAmount(param.getRedPacketTotalAmount());
        plan.setRedPacketTotalNum(param.getRedPacketTotalNum());
        plan.setSentTime(param.getSentTime());
        plan.setRedPacketSourceUserId(this.imChatRoomProperties.getChatRoomTimingRedPacketAssistantUserId());
        plan.setRedPacketRemark(this.imChatRoomProperties.getChatRoomTimingRedPacketRemark());
        plan.setRedPacketName("\u5b9a\u65f6\u7ea2\u5305");
        plan.setRedPacketSource(Byte.valueOf((byte)1));
        plan.setRedPacketType(Byte.valueOf((byte)1));
        plan.setSendTimes(Integer.valueOf(0));
        plan.setSentDate(null);
        plan.setRedPacketAmountType(Byte.valueOf((byte)1));
        plan.setRedPacketAuthType(Byte.valueOf((byte)1));
        plan.setRedPacketDistributeArithmeticType(Byte.valueOf((byte)1));
        plan.setTimingType(Byte.valueOf((byte)1));
        plan.setTotalTimes(Integer.valueOf(-1));
        plan.setStatus(Byte.valueOf((byte)1));
        plan.setCreateTime(now);
        plan.setDeleteFlag(Byte.valueOf((byte)0));
        plan.setDeleteTime(null);
        plan.setId(this.sequenceCreater.nextLongId());
        plan.setModifyTime(now);
        this.imTimingRedPacketPlanExtendMapper.insertSelective(plan);
        this.addTask(plan.getId());
        return Json.ok();
    }

    private boolean hasNearest(List<ImTimingRedPacketPlan> imTimingRedPacketPlans, Date sentTime) {
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime1 = LocalDateTime.of(LocalDate.now(), LocalDateTime.ofInstant(sentTime.toInstant(), zone).toLocalTime());
        return imTimingRedPacketPlans.stream().filter(p -> {
            if (Objects.equals(p.getStatus().intValue(), 1) && Objects.equals(p.getTimingType().intValue(), 1)) {
                LocalDateTime localDateTime2 = LocalDateTime.of(LocalDate.now(), LocalDateTime.ofInstant(p.getSentTime().toInstant(), zone).toLocalTime());
                Duration duration = localDateTime2.isBefore(localDateTime1) ? Duration.between(localDateTime2, localDateTime1) : Duration.between(localDateTime1, localDateTime2);
                return duration.toMinutes() < 5L;
            }
            return false;
        }).count() > 0L;
    }

    private boolean checkAmt(BigDecimal redPacketTotalAmount, Integer redPacketTotalNum) {
        return redPacketTotalAmount.divide(BigDecimal.valueOf(redPacketTotalNum.intValue()), 2, RoundingMode.HALF_DOWN).compareTo(MIX) >= 0;
    }

    private Message checkChatRoomStatus(String chatRoomId) {
        ImChatroom chatroom = this.imChatroomExtendMapper.selectByChatRoomId(chatRoomId);
        if (Objects.isNull(chatroom)) {
            return Message.build((boolean)false).setMessage("\u804a\u5929\u5ba4\u4e0d\u5b58\u5728");
        }
        return Message.build();
    }

    @Override
    public Json updateTimingRedPacketPlan(UpdateTimingRedPacketPlanParam param) {
        ImTimingRedPacketPlan plan = this.imTimingRedPacketPlanExtendMapper.selectByPrimaryKey(param.getId());
        if (Objects.isNull(plan)) {
            return Json.badReqeuset((String)"\u7ea2\u5305\u4e0d\u5b58\u5728");
        }
        if (Objects.nonNull(param.getSentTime())) {
            List<ImTimingRedPacketPlan> imTimingRedPacketPlans = this.imTimingRedPacketPlanExtendMapper.listPlansByChatRoomId(plan.getRedPacketTargetId());
            if (this.hasNearest(imTimingRedPacketPlans = imTimingRedPacketPlans.stream().filter(p -> !Objects.equals(p.getId(), param.getId())).collect(Collectors.toList()), param.getSentTime())) {
                return Json.badReqeuset((String)"\u8bf7\u52ff\u6dfb\u52a0\u76f8\u5dee\u65f6\u95f45m\u4e4b\u5185\u7684\u7ea2\u5305");
            }
        }
        if (!this.checkAmt(param.getRedPacketTotalAmount(), param.getRedPacketTotalNum())) {
            return Json.badReqeuset((String)"\u5e73\u5747\u6bcf\u4e2a\u7ea2\u5305\u4e0d\u53ef\u5c11\u4e8e0.01\u5143");
        }
        Message message = this.checkChatRoomStatus(plan.getRedPacketTargetId());
        if (!message.isSuccess()) {
            return Json.badReqeuset((String)message.getLastMessage());
        }
        ImTimingRedPacketPlan update = new ImTimingRedPacketPlan();
        BeanUtils.copyProperties((Object)param, (Object)update);
        Date now = new Date();
        update.setModifyTime(now);
        this.imTimingRedPacketPlanExtendMapper.updateByPrimaryKeySelective(update);
        this.addTask(param.getId());
        return Json.ok();
    }

    private void addTask(Long timingRedPacketPlanId) {
        CreateRedPacketTaskFacadeParam param = new CreateRedPacketTaskFacadeParam();
        param.setTimingRedPacketPlanId(timingRedPacketPlanId);
        this.scheduledThreadPoolExecutor.schedule(() -> {
            boolean res;
            if (log.isDebugEnabled()) {
                log.debug("\u521b\u5efaid: {} \u7684\u7ea2\u5305\u5b9a\u65f6\u4efb\u52a1", (Object)timingRedPacketPlanId);
            }
            if (!(res = this.imIntegrationService.createRedPacketTask(param).booleanValue())) {
                log.warn("\u521b\u5efaid: {}\u7684\u7ea2\u5305\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01", (Object)timingRedPacketPlanId);
            }
        }, 2L, TimeUnit.SECONDS);
    }

    private void removeTask(Long timingRedPacketPlanId) {
        RemoveRedPacketTaskFacadeParam param = new RemoveRedPacketTaskFacadeParam();
        param.setTimingRedPacketPlanId(timingRedPacketPlanId);
        boolean res = this.imIntegrationService.removeRedPacketTask(param);
        if (!res) {
            log.warn("\u79fb\u9664id: {}\u7684\u7ea2\u5305\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01", (Object)timingRedPacketPlanId);
        }
    }

    @Override
    public PageWarper<ImTimingRedPacketPlanVO> listPlansByChatRoomId(ListPlansByChatRoomIdParam param) {
        Page page = PageHelper.startPage((Object)param).doSelectPage(() -> this.imTimingRedPacketPlanExtendMapper.listPlansByChatRoomId(param.getChatRoomId()));
        PageWarper pageWarper = new PageWarper((List)page);
        pageWarper.setList(page.getResult().stream().map(this::build).collect(Collectors.toList()));
        return pageWarper;
    }

    @Override
    public Json deleteTimingRedPacketPlan(IdParam param) {
        ImTimingRedPacketPlan update = new ImTimingRedPacketPlan();
        Date now = new Date();
        update.setId(param.getId());
        update.setDeleteTime(now);
        update.setDeleteFlag(Byte.valueOf((byte)1));
        update.setModifyTime(now);
        this.imTimingRedPacketPlanExtendMapper.updateByPrimaryKeySelective(update);
        this.removeTask(param.getId());
        return Json.ok();
    }
}

