/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.market.impl;

import com.bxm.localnews.admin.domain.MarketOrderMapper;
import com.bxm.localnews.admin.enums.MarketCommodityTypeEnum;
import com.bxm.localnews.admin.param.MarketOrderQueryParam;
import com.bxm.localnews.admin.service.market.MarketOrderService;
import com.bxm.localnews.admin.utils.ExportUtils;
import com.bxm.localnews.admin.utils.dto.ExportDataRow;
import com.bxm.localnews.admin.utils.dto.ExportModel;
import com.bxm.localnews.admin.vo.MarketOrder;
import com.bxm.localnews.admin.vo.MarketOrderExpressage;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MarketOrderServiceImpl
implements MarketOrderService {
    private static final Logger logger = LoggerFactory.getLogger(MarketOrderServiceImpl.class);
    @Resource
    private MarketOrderMapper marketOrderMapper;

    @Override
    public PageWarper<MarketOrder> getList(MarketOrderQueryParam param) {
        return new PageWarper(this.marketOrderMapper.getList(param));
    }

    @Override
    public int saveOrUpdate(MarketOrderExpressage marketOrderExpressage) {
        if (null == marketOrderExpressage.getId()) {
            return 0;
        }
        MarketOrder order = new MarketOrder();
        order.setId(marketOrderExpressage.getId());
        order.setStatus(Integer.valueOf(0));
        order.setExpressageCompany(marketOrderExpressage.getExpressageCompany());
        order.setExpressageNo(marketOrderExpressage.getExpressageNo());
        return this.marketOrderMapper.updateByPrimaryKeySelective(order);
    }

    @Override
    public void exportExcel(MarketOrderQueryParam param, HttpServletResponse response) {
        param.setPageSize(Integer.valueOf(0));
        List orderList = this.marketOrderMapper.getList(param);
        try {
            String fileName = "\u5151\u6362\u8ba2\u5355\u5217\u8868.xls";
            String headNames = "\u8ba2\u5355\u7f16\u53f7,\u7528\u6237id,\u7528\u6237\u6635\u79f0,\u5546\u54c1\u540d\u79f0,\u5151\u6362\u7c7b\u578b,\u8ba2\u5355\u72b6\u6001,\u521b\u5efa\u65f6\u95f4,\u6536\u8d27\u4fe1\u606f,\u7269\u6d41\u5355\u53f7,\u7269\u6d41\u516c\u53f8";
            ExportModel exportModel = new ExportModel();
            exportModel.setHeadNames(headNames);
            ArrayList<ExportDataRow> dataRowList = new ArrayList<ExportDataRow>();
            if (CollectionUtils.isNotEmpty((Collection)orderList)) {
                for (MarketOrder order : orderList) {
                    ExportDataRow exportDataRow = new ExportDataRow();
                    ArrayList<String> dataColumnList = new ArrayList<String>();
                    dataColumnList.add(order.getOrderNo());
                    dataColumnList.add(order.getUserId() + "");
                    dataColumnList.add(order.getUserName());
                    dataColumnList.add(order.getCommodityTitle());
                    dataColumnList.add(MarketCommodityTypeEnum.valueOf((String)order.getCommodityType()).getDesc());
                    if (null == order.getStatus()) {
                        dataColumnList.add("");
                    } else if (0 == order.getStatus()) {
                        dataColumnList.add("\u5f85\u6263\u9664");
                    } else if (1 == order.getStatus()) {
                        dataColumnList.add("\u5df2\u5b8c\u6210");
                    } else if (2 == order.getStatus()) {
                        dataColumnList.add("\u4f59\u989d\u4e0d\u8db3");
                    }
                    dataColumnList.add(DateUtils.formatDateTime((Date)order.getCreateTime()));
                    dataColumnList.add(order.getFinalAddress());
                    dataColumnList.add(order.getExpressageNo());
                    dataColumnList.add(order.getExpressageCompany());
                    exportDataRow.setDataColumnList(dataColumnList);
                    dataRowList.add(exportDataRow);
                }
            }
            exportModel.setDataRowList(dataRowList);
            byte[] result = ExportUtils.makeExcel((ExportModel)exportModel, (String)fileName);
            ExportUtils.exportToResponse((HttpServletResponse)response, (String)fileName, (byte[])result, (String)"excel");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5151\u6362\u8ba2\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

