/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.EquipmentInfoMapper;
import com.bxm.localnews.admin.domain.RecommendNativeMapper;
import com.bxm.localnews.admin.domain.UserInviteHistoryMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.UserVipMapper;
import com.bxm.localnews.admin.domain.auth.UserRoleMapper;
import com.bxm.localnews.admin.dto.EquipmentDTO;
import com.bxm.localnews.admin.dto.security.UserInfoDTO;
import com.bxm.localnews.admin.dto.security.UserVipDTO;
import com.bxm.localnews.admin.facade.MerchantFeignService;
import com.bxm.localnews.admin.integration.BizIntegrationService;
import com.bxm.localnews.admin.integration.UserIntegrationService;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.param.security.UserPhoneParam;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.UserInviteHistoryBean;
import com.bxm.localnews.admin.vo.UserLoginHistory;
import com.bxm.localnews.admin.vo.auth.UserRoleBean;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AdminUserBaseInfoServiceImpl
extends BaseService
implements AdminUserBaseInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserBaseInfoServiceImpl.class);
    @Resource
    private UserMapper userBaseInfoMapper;
    @Resource
    private EquipmentInfoMapper equipmentInfoMapper;
    @Resource
    private BizIntegrationService bizIntegrationService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Autowired
    private MerchantFeignService merchantFeignService;
    @Resource
    private UserVipMapper userVipMapper;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private RecommendNativeMapper recommendNativeMapper;
    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public PageWarper<UserInfoDTO> queryUserInfoDTO(UserInfoParam param) {
        PageWarper pageWarper = null;
        pageWarper = null != param.getHasOpenCard() ? new PageWarper(this.userBaseInfoMapper.queryUserInfoListHasOpenVip(param)) : new PageWarper(this.userBaseInfoMapper.queryUserInfoList(param));
        if (!CollectionUtils.isEmpty((Collection)pageWarper.getList())) {
            ArrayList userIdList = Lists.newArrayList();
            pageWarper.getList().forEach(item -> userIdList.add(Long.valueOf(item.getUserId())));
            List userRoles = this.userRoleMapper.queryUserRoles((List)userIdList);
            if (userRoles.size() > 0) {
                pageWarper.getList().forEach(user -> {
                    List userRoleCodes = userRoles.stream().filter(userRole -> userRole.getUserId().equals(Long.valueOf(user.getUserId()))).map(UserRoleBean::getRoleCode).collect(Collectors.toList());
                    user.setRoles(userRoleCodes);
                });
            }
            List listUserVip = this.userVipMapper.getVipListByUserIds((List)userIdList);
            pageWarper.getList().forEach(userInfo -> {
                boolean hit = false;
                if (listUserVip.size() > 0) {
                    for (UserVipDTO vipEntity : listUserVip) {
                        if (!String.valueOf(vipEntity.getUserId()).equals(userInfo.getUserId())) continue;
                        userInfo.setTotalOpenNum(Integer.valueOf(vipEntity.getActiveTimes() + vipEntity.getMaxTimes()));
                        userInfo.setLeftOpenNum(vipEntity.getMaxTimes());
                        hit = true;
                        break;
                    }
                }
                if (!hit) {
                    userInfo.setLeftOpenNum(Integer.valueOf(0));
                    userInfo.setTotalOpenNum(Integer.valueOf(0));
                }
            });
        }
        return pageWarper;
    }

    @Override
    public User selectByUserId(Long userId) {
        return this.userBaseInfoMapper.selectByUserId(userId.longValue());
    }

    @Override
    public boolean updateUserBlack(Map<String, Object> map) {
        return this.userBaseInfoMapper.updateUserBlack(map);
    }

    @Override
    public Boolean deleteUser(Long userId) {
        UserInviteHistoryBean inviteHistoryBean;
        EquipmentDTO equipmentDTO;
        UserLoginHistory userLoginHistory;
        Long id = this.nextId();
        User user = this.selectByUserId(userId);
        if (null == user) {
            LOG.error("\u6839\u636e\u6b64userId:{}\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f,\u5220\u9664\u7528\u6237\u5931\u8d25", (Object)userId);
            return false;
        }
        this.redisStringAdapter.remove(RedisConfig.USER_INFO.copy().appendKey((Object)userId));
        String weChat = user.getWeixin() == null ? null : user.getWeixin() + id;
        this.userBaseInfoMapper.updateUser(userId, weChat);
        this.userBaseInfoMapper.updateVipRecord(userId, weChat);
        if (StringUtils.isNotEmpty((CharSequence)user.getWeixin())) {
            this.userBaseInfoMapper.updateVipViewRecord(user.getWeixin(), weChat);
        }
        if (null != (userLoginHistory = this.userBaseInfoMapper.selectHistoryByUserId(userId.longValue())) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{userLoginHistory.getEquipment()}) && null != (equipmentDTO = this.bizIntegrationService.getDevice(userLoginHistory.getEquipment())) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentDTO.getId()})) {
            this.userBaseInfoMapper.deleteUserEquipment(user.getEquipment());
            this.equipmentInfoMapper.deleteByPrimaryKey(equipmentDTO.getId());
        }
        this.recommendNativeMapper.deleteByPrimaryKey(userId);
        this.userBaseInfoMapper.deleteUser(userId);
        this.clearUserCache(userId);
        this.redisHashMapAdapter.remove(RedisConfig.USER_VIP_INFO, new String[]{String.valueOf(userId)});
        this.redisHashMapAdapter.remove(RedisConfig.USER_VIP_CODE_LEFT_USE_NUM, new String[]{String.valueOf(userId)});
        this.userVipMapper.delete(userId);
        if (this.userInviteHistoryMapper.delete(userId) > 0 && null != (inviteHistoryBean = this.userInviteHistoryMapper.selectByUserId(userId))) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(inviteHistoryBean.getInviteUserId());
            ids.add(inviteHistoryBean.getInviteCreatedUserId());
            ids.add(inviteHistoryBean.getInviteSuperUserId());
            ids.add(inviteHistoryBean.getCreatedUserId());
            this.userBaseInfoMapper.decrInviteNum(ids);
            this.userIntegrationService.delUserCacheBatch(ids);
        }
        this.merchantFeignService.deleteMerchantInfoByUid(userId);
        return true;
    }

    private void clearUserCache(Long userId) {
        this.redisStringAdapter.remove(RedisConfig.USER_INFO.copy().appendKey((Object)userId));
    }

    @Override
    public List<UserInfoDTO> getVirtualUserList() {
        return this.userBaseInfoMapper.getVirtualUserList();
    }

    @Override
    public Message modifyPhoneNo(UserPhoneParam param) {
        if (StringUtils.length((CharSequence)param.getPhone()) != 11 || !NumberUtils.isDigits((String)param.getPhone())) {
            return Message.build((boolean)false, (String)"\u8f93\u5165\u7684\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u624b\u673a\u53f7\u7801");
        }
        UserInfoDTO userInfoDTO = this.userBaseInfoMapper.queryByPhone(param.getPhone());
        if (userInfoDTO != null && Objects.equals(param.getUserId() + "", userInfoDTO.getUserId())) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5f53\u524d\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u662f\u8be5\u53f7\u7801");
        }
        if (userInfoDTO != null) {
            return Message.build((boolean)false, (String)("\u8be5\u53f7\u7801\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\uff0cID:[" + userInfoDTO.getUserId() + "],\u6635\u79f0:[" + userInfoDTO.getUserName() + "]"));
        }
        Message message = Message.build((int)this.userBaseInfoMapper.updatePhone(param));
        if (message.isSuccess()) {
            this.clearUserCache(param.getUserId());
        }
        return message;
    }
}

