/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.domain.auth.UserRoleMapper;
import com.bxm.localnews.admin.dto.UserManageDTO;
import com.bxm.localnews.admin.integration.UserAuthCodeIntegrationService;
import com.bxm.localnews.admin.param.UserManageParam;
import com.bxm.localnews.admin.param.security.UserRoleParam;
import com.bxm.localnews.admin.service.security.ManageUserAdminInfoService;
import com.bxm.localnews.admin.vo.Message;
import com.bxm.localnews.auth.enums.RoleCodeEnum;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManageUserAdminInfoServiceImpl
implements ManageUserAdminInfoService {
    private static final Logger log = LoggerFactory.getLogger(ManageUserAdminInfoServiceImpl.class);
    private final UserRoleMapper userRoleMapper;
    private final UserAuthCodeIntegrationService userAuthCodeIntegrationService;

    @Override
    public UserManageDTO getAdminInfo(Long userId) {
        List userRoles = this.userRoleMapper.queryUserRoles(Collections.singletonList(userId));
        UserManageDTO manageDTO = new UserManageDTO();
        manageDTO.setUserId(userId);
        manageDTO.setForumManageFlag(Boolean.valueOf(userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.FORUM_ADMIN.name()))));
        manageDTO.setChatRoomAdminFlag(Boolean.valueOf(userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.CHAT_ROOM_ADMIN.name()))));
        return manageDTO;
    }

    @Override
    public Message editAdminInfo(UserManageParam param) {
        List userRoles = this.userRoleMapper.queryUserRoles(Collections.singletonList(param.getUserId()));
        if (userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.CHAT_ROOM_ADMIN.name()))) {
            if (!Objects.equals(param.getChatRoomAdminFlag(), Boolean.TRUE)) {
                this.userAuthCodeIntegrationService.removeRole(this.build(param.getUserId(), RoleCodeEnum.CHAT_ROOM_ADMIN.name()));
            }
        } else if (Objects.equals(param.getChatRoomAdminFlag(), Boolean.TRUE)) {
            this.userAuthCodeIntegrationService.addRole(this.build(param.getUserId(), RoleCodeEnum.CHAT_ROOM_ADMIN.name()));
        }
        if (userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.FORUM_ADMIN.name()))) {
            if (!Objects.equals(param.getForumManageFlag(), Boolean.TRUE)) {
                this.userAuthCodeIntegrationService.removeRole(this.build(param.getUserId(), RoleCodeEnum.FORUM_ADMIN.name()));
            }
        } else if (Objects.equals(param.getForumManageFlag(), Boolean.TRUE)) {
            this.userAuthCodeIntegrationService.addRole(this.build(param.getUserId(), RoleCodeEnum.FORUM_ADMIN.name()));
        }
        return null;
    }

    private UserRoleParam build(Long userId, String roleCode) {
        UserRoleParam param = new UserRoleParam();
        param.setUserId(userId);
        param.setRoleCode(roleCode);
        return param;
    }

    public ManageUserAdminInfoServiceImpl(UserRoleMapper userRoleMapper, UserAuthCodeIntegrationService userAuthCodeIntegrationService) {
        this.userRoleMapper = userRoleMapper;
        this.userAuthCodeIntegrationService = userAuthCodeIntegrationService;
    }
}

